package sdk.main.core.inappmessaging.display

import android.view.Gravity
import androidx.compose.ui.Alignment

enum class ViewportPosition(val gravity: Int, val alignment: Alignment) {
    CENTER(Gravity.CENTER, Alignment.Center),
    CENTER_START(Gravity.START or Gravity.CENTER_VERTICAL, Alignment.CenterStart),
    CENTER_END(Gravity.END or Gravity.CENTER_VERTICAL, Alignment.CenterEnd),
    CENTER_TOP(Gravity.TOP or Gravity.CENTER_HORIZONTAL, Alignment.TopCenter),
    CENTER_BOTTOM(Gravity.BOTTOM or Gravity.CENTER_HORIZONTAL, Alignment.BottomCenter),
    TOP_START(Gravity.START or Gravity.TOP, Alignment.TopStart),
    TOP_END(Gravity.END or Gravity.TOP, Alignment.TopEnd),
    BOTTOM_START(Gravity.START or Gravity.BOTTOM, Alignment.BottomStart),
    BOTTOM_END(Gravity.END or Gravity.BOTTOM, Alignment.BottomEnd);
}
