package sdk.main.core.inappmessaging.display.internal

import android.util.Log
import ir.intrack.android.sdk.BuildConfig

object Logging {
    private const val TAG = "CoreProxy"

    /**
     * Log a number with a label.
     */
    fun logdNumber(label: String, num: Float) {
        logd("$label: $num")
    }

    /**
     * Log two numbers as a coordinate pair, with a label.
     */
    fun logdPair(label: String, fst: Float, snd: Float) {
        logd("$label: ($fst, $snd)")
    }

    /**
     * Log a big header,
     */
    fun logdHeader(label: String) {
        logd("============ $label ============")
    }

    /**
     * Log a message if in debug mode.
     */
    fun logd(message: String) {
        if (BuildConfig.DEBUG || Log.isLoggable(TAG, Log.DEBUG)) {
            Log.d(TAG, message)
        }
    }

    fun logd(tag: String?, message: String) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message)
        }
    }

    /**
     * Log error messages normally but add a consistent TAG
     */
    fun loge(message: String) {
        Log.e(TAG, message)
    }

    /**
     * Log error messages normally but add a consistent TAG
     */
    fun loge(message: String?, e: Exception?) {
        Log.e(TAG, message, e)
    }

    /**
     * Log info messages normally but add a consistent TAG
     */
    fun logi(message: String) {
        if (Log.isLoggable(TAG, Log.INFO)) {
            Log.i(TAG, message)
        }
    }
}
