package sdk.main.core.inappmessaging.display.mraid

import sdk.main.core.inappmessaging.display.Configuration
import sdk.main.core.inappmessaging.model.message.IAMMessage

object MraidCommands {
    // solid command
    const val JS = "javascript:"
    private const val JS_INJECT_WINDOW_COMMAND = "${JS}window."
    private const val JS_INJECT_MRAID_COMMAND = "${JS_INJECT_WINDOW_COMMAND}mraid."
    private const val JS_INJECT_MRAID_UTIL_COMMAND = "${JS_INJECT_MRAID_COMMAND}util."
    private const val UNDEFINED = "undefined"
    const val URL = "url"
    const val URI = "uri"
    const val SET_ORIENTATION_PROPERTIES = "setOrientationProperties"
    const val ORIENTATION = "orientation"
    const val MRAID_SCHEME = "mraid://"
    const val REGEX_SPLIT_BACK_SPLASH = "\\?"
    const val AUTH_KEY = "authKey"
    const val APP_KEY = "appKey"
    const val DEVICE_ID = "deviceId"
    const val USER_ID = "userId"
    const val CLOSE = "close"
    const val UNLOAD = "unload"
    const val CREATE_CALENDAR_EVENT = "createCalendarEvent"
    const val PLAY_VIDEO = "playVideo"
    const val STORE_PICTURE = "storePicture"
    const val INLINE_VIDEO = "inlineVideo"
    const val OPEN = "open"
    const val AUDIO_VOLUME_CHANGE = "audioVolumeChange"
    const val ENABLE = "enable"
    const val UTF_8 = "UTF-8"
    const val VIDEO_MP4 = "video/mp4"
    const val TEXT_HTML = "text/html"
    const val HTTP = "http"
    const val MRAID_MINIFIED_FILE_NAME = "mraid.min.js"
    const val TEXT_JS = "text/javascript"
    const val RECORD_INTERNAL_EVENT = "recordNativeEvent"
    const val COPY_TO_CLIPBOARD = "copyToClipboard"
    const val SET_CONFIGURATION = "setConfiguration"
    const val DEEPLINK = "deeplink"
    const val RECORD_NATIVE_CLICK_EVENT = "recordNativeClickEvent"

    fun close() = "${JS_INJECT_MRAID_COMMAND}close()"

    fun setPlacementType(placementType: String) =
        "${JS_INJECT_MRAID_UTIL_COMMAND}setPlacementType('$placementType')"

    fun stateChangeEvent(event: MraidState) = "${JS_INJECT_MRAID_UTIL_COMMAND}stateChangeEvent('${event.label}')"

    fun readyEvent() = "${JS_INJECT_MRAID_UTIL_COMMAND}readyEvent()"

    fun setCurrentAppOrientation(
        orientation: Orientation
    ) = "${JS_INJECT_MRAID_UTIL_COMMAND}setCurrentAppOrientation('${orientation.label}')"

    fun setSupports(
        feature: String,
        value: Boolean,
    ) = "${JS_INJECT_MRAID_UTIL_COMMAND}setSupports('$feature',$value)"

    fun exposureChangeEvent(exposureVal: String) =
        "${JS_INJECT_MRAID_UTIL_COMMAND}exposureChangeEvent($exposureVal)"

    fun audioVolumeChangeEvent(volume: String) =
        "${JS_INJECT_MRAID_UTIL_COMMAND}audioVolumeChangeEvent($volume)"

    fun sizeChangeEvent(configuration: Configuration) =
        "${JS_INJECT_MRAID_UTIL_COMMAND}sizeChangeEvent('$configuration')"

    fun getAuthKey(authKey: String) =
        "${JS_INJECT_WINDOW_COMMAND}getAuthKey('$authKey'); window.getAuthKey = undefined;"

    fun getAppKey(appKey: String) =
        "${JS_INJECT_WINDOW_COMMAND}getAppKey('$appKey'); window.getAppKey = undefined;"

    fun getDeviceId(deviceId: String?) = "$JS_INJECT_WINDOW_COMMAND${
        if (deviceId == null) {
            "getDeviceId($UNDEFINED); window.getDeviceId = undefined;"
        } else {
            "getDeviceId('$deviceId'); window.getDeviceId = undefined;"
        }
    }"

    fun getUserId(userId: String?) = "$JS_INJECT_WINDOW_COMMAND${
        if (userId == null) {
            "getUserId($UNDEFINED); window.getUserId = undefined;"
        } else {
            "getUserId('$userId'); window.getUserId = undefined;"
        }
    }"

    fun setEnvironment(env: MraidEnvironment) =
        "${JS_INJECT_WINDOW_COMMAND}MRAID_ENV = ${env.toJSON()}"

    // size in PX
    fun setMaxSize(
        maxWidth: Float,
        maxHeight: Float,
    ) = "${JS_INJECT_MRAID_UTIL_COMMAND}setMaxSize($maxWidth, $maxHeight)"

    // size in PX
    fun setScreenSize(
        screenWidth: Float,
        screenHeight: Float,
        displayMetrics: MraidDisplayMetrics,
    ) = "${JS_INJECT_MRAID_UTIL_COMMAND}setScreenSize(${screenWidth}, ${screenHeight}, ${displayMetrics.toJSON()})"

    fun pageFinished() = "${JS_INJECT_MRAID_UTIL_COMMAND}pageFinished()"

    fun setConfiguration(configuration: Configuration) =
        "${JS_INJECT_MRAID_UTIL_COMMAND}setConfiguration('$configuration')"

    fun setMessage(message: IAMMessage): String = "${JS_INJECT_MRAID_UTIL_COMMAND}setMessage('$message')"
}
