package sdk.main.core.inappmessaging.display.mraid

enum class MraidState(val label: String) {
    Loading("loading"),
    Default("default"),
    Resized("resized"),
    Expanded("expanded"),
    Hidden("hidden");

    companion object {
        fun fromString(value: String?): MraidState? {
            if (value.isNullOrEmpty()) {
                return null
            }

            for (state in entries) {
                if (state.label.equals(value, true)) {
                    return state
                }
            }

            return null
        }
    }
}
