package sdk.main.core.inappmessaging.display.mraid

import android.app.Activity
import android.content.pm.ActivityInfo
import android.content.res.Configuration
import android.view.Surface

enum class Orientation(val label: String, val androidOrientation: Int) {
    Portrait("PORTRAIT", ActivityInfo.SCREEN_ORIENTATION_PORTRAIT),
    PortraitReverse("PORTRAIT_REVERSE", ActivityInfo.SCREEN_ORIENTATION_REVERSE_PORTRAIT),
    Landscape("LANDSCAPE", ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE),
    LandscapeReverse("LANDSCAPE_REVERSE", ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE),
    Unspecified("UNSPECIFIED", ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);

    companion object {
        fun fromString(value: String?): Orientation {
            if (value.isNullOrBlank()) return Unspecified

            for (orientation in entries) {
                if (orientation.label.equals(value, true)) {
                    return orientation
                }
            }
            return Unspecified
        }

        fun fromAndroidActivity(activity: Activity): Orientation {
            val rotation: Int = activity.windowManager.defaultDisplay.rotation
            return when (activity.resources.configuration.orientation) {
                Configuration.ORIENTATION_PORTRAIT -> {
                    when (rotation) {
                        Surface.ROTATION_0 -> Portrait
                        Surface.ROTATION_180 -> PortraitReverse
                        else -> Unspecified
                    }
                }

                Configuration.ORIENTATION_LANDSCAPE -> {
                    when (rotation) {
                        Surface.ROTATION_90 -> Landscape
                        Surface.ROTATION_270 -> LandscapeReverse
                        else -> Unspecified
                    }
                }

                else -> Unspecified
            }
        }
    }
}
