package sdk.main.core.inappmessaging.model.message

import sdk.main.core.inappmessaging.model.message.enumeration.Conjunction

data class ActivityData(
    var conjunction: Conjunction? = null,
    var terms: ArrayList<Terms>? = arrayListOf(),
)

internal fun ActivityData.accepts(screenData: Map<String?, Any?>?) =
    when (conjunction) {
        Conjunction.AND -> terms?.all { it.accepts(screenData) } == true
        Conjunction.OR -> terms?.any { it.accepts(screenData) } == true
        null -> false
    }
