package sdk.main.core.inappmessaging.model.message

import sdk.main.core.ScreenUnion
import sdk.main.core.inappmessaging.model.message.enumeration.Conjunction

data class ActivityNames(
    var conjunction: Conjunction? = null,
    var terms: ArrayList<Terms> = arrayListOf(),
)

internal fun ActivityNames.doesScreenCompliesTo(screenUnion: ScreenUnion) =
    when (conjunction ?: Conjunction.AND) {
        Conjunction.AND -> terms.all { it.doesScreenCompliesTo(screenUnion) }
        Conjunction.OR -> terms.any { it.doesScreenCompliesTo(screenUnion) }
    }
