package sdk.main.core.inappmessaging.model.message

import sdk.main.core.ext.withNegate
import sdk.main.core.inappmessaging.model.message.enumeration.Operator

data class ActivityViews(
    var negate: Boolean = false,
    var operator: Operator? = null,
    var value: String? = null,
    var dataType: String? = null,
)

private val String?.toIntRange: IntRange?
    get() = this?.run {
        val parts = split(",")
        if (parts.size == 2) {
            val start = parts[0].toIntOrNull() ?: return@run null
            val end = parts[1].toIntOrNull() ?: return@run null
            start..end
        } else {
            null
        }
    }

fun ActivityViews?.accepts(viewCount: Int): Boolean = withNegate(this?.negate) {
    val objStr = viewCount.toString()
    val valueInt = this?.value?.toIntOrNull()

    val compliesToCondition = when (this?.operator) {
        Operator.EQUAL_TO -> valueInt == viewCount
        Operator.NOT_EQUAL_TO -> valueInt != viewCount
        Operator.IS_NOT_EMPTY -> true
        Operator.ONE_OF -> value?.split(",")?.contains(objStr) == true
        Operator.NONE_OF -> value?.split(",")?.contains(objStr) != true
        Operator.STARTS_WITH -> false
        Operator.ENDS_WITH -> false
        Operator.MATCHES_REGEX -> false
        Operator.CONTAINS -> value?.split(",")?.contains(objStr) == true
        Operator.LESS_THAN -> viewCount < (valueInt ?: return@withNegate true)
        Operator.LESS_THAN_OR_EQUAL_TO -> viewCount <= (valueInt ?: return@withNegate true)
        Operator.GREATER_THAN -> viewCount > (valueInt ?: return@withNegate true)
        Operator.GREATER_THAN_OR_EQUAL_TO -> viewCount >= (valueInt ?: return@withNegate true)
        Operator.BETWEEN -> value.toIntRange?.contains(viewCount) == true
        Operator.NOT_BETWEEN -> value.toIntRange?.contains(viewCount) != true
        null -> true
    }
    compliesToCondition
}
