package sdk.main.core.inappmessaging.model.message

import sdk.main.core.UserDetails
import sdk.main.core.inappmessaging.model.message.enumeration.Conjunction

data class CustomEvent(
    var conjunction: Conjunction? = null,
    var terms: ArrayList<Terms>? = null,
)

internal data class EventModel(
    val key: String,
    val segmentation: MutableMap<String, Any?>,
    val userDetails: UserDetails<*>?,
)

internal fun CustomEvent.accepts(event: EventModel) =
    when (conjunction) {
        Conjunction.AND -> terms?.all { it.accepts(event) } == true
        Conjunction.OR -> terms?.any { it.accepts(event) } == true
        null -> false
    }
