package sdk.main.core.pushmessaging

import kotlin.IllegalArgumentException
import kotlin.String

/**
 * Enum for message types.
 */

enum class MessageType {
    TEXT, CAROUSEL, RATING, BANNER, TIMER;

    companion object {
        /**
         * Parse a string into a MessageType.
         * Returns null if the input is invalid.
         */
        fun fromString(type: String?): MessageType? {
            return try {
                type?.uppercase()?.let { valueOf(it) }
            } catch (e: IllegalArgumentException) {
                null // Return null for invalid or missing type
            }
        }
    }

}
