package sdk.main.core

import android.content.Context
import android.content.SharedPreferences

class AppInfoPrefs(context: Context) {

    private val preferences: SharedPreferences =
        context.getSharedPreferences(PREFERENCES, Context.MODE_PRIVATE)

    fun getLatestAppVersionCode(): Int {
        return preferences.getInt(LATEST_VERSION_CODE, -1)
    }

    fun setLatestAppVersionCode(latestVersionCode: Int) {
        preferences.edit().putInt(LATEST_VERSION_CODE, latestVersionCode).apply()
    }

    fun getLatestAppVersionName(): String? {
        return preferences.getString(LATEST_VERSION_NAME, null)
    }

    fun setLatestAppVersionName(latestVersionName: String) {
        preferences.edit().putString(LATEST_VERSION_NAME, latestVersionName).apply()
    }

    companion object {
        private const val PREFERENCES = "SDK_STORE_APP_INFO"
        private const val LATEST_VERSION_CODE = "LATEST_VERSION_CODE"
        private const val LATEST_VERSION_NAME = "LATEST_VERSION_NAME"
    }

}
