package sdk.main.core;

import android.content.Context;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Just a public holder class for Messaging-related display logic, listeners, managers, etc.
 */
public class CustomChannelHandler {
    protected static final String CUSTOM_CHANNEL_DELIVERY_EVENT_KEY = "custom_delivered";
    protected static final String CUSTOM_CHANNEL_CLICK_EVENT_KEY = "custom_click";

    protected static void recordEvent(final Context context, final String token, final EventType eventType) throws Exception {
        CoreInternal.sharedInstance().L.d("[CustomChannelHandler, recordEvent] recording" + eventType);

        String urlString = "https://api.intrack.ir";
        if (eventType == EventType.CLICK) {
            urlString += "/api/sdk/track/clicked?token=" + token;
        } else {
            urlString += "/api/sdk/track/delivered?token=" + token;
        }

        ExecutorService executor = Executors.newSingleThreadExecutor();
        String finalUrlString = urlString;
        executor.execute(() -> {
            HttpURLConnection urlConnection = null;
            try {
                URL requestUrl = new URL(finalUrlString);
                urlConnection = (HttpURLConnection) requestUrl.openConnection();
                int code = urlConnection.getResponseCode();
                CoreInternal.sharedInstance().L.d("[PushHandler, displayMessage] delivery has sent" + code);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        });

//        String instanceId;
//        try {
//            byte[] encodedData = Base64.decode(token, Base64.DEFAULT);
//            String encodedString = new String(encodedData);
//            JsonObject convertedObject = new Gson().fromJson(encodedString, JsonObject.class);
//            instanceId = String.valueOf(convertedObject.get("id")).replaceAll("\"","");
//        } catch (Exception ignored) {
//            throw new Exception("token is not valid");
//        }

        if (CoreInternal.sharedInstance().isInitialized()) {
            Map<String, Object> eventData = new HashMap<>();
            eventData.put("i", token);
            String eventName;
            if (eventType == EventType.CLICK) {
                eventName = CUSTOM_CHANNEL_CLICK_EVENT_KEY;
            } else {
                eventName = CUSTOM_CHANNEL_DELIVERY_EVENT_KEY;
            }
            CoreInternal.sharedInstance().events().recordSystemEvent(eventName, eventData);
            CoreInternal.sharedInstance().sendEventsForced();
        } else {
            if (eventType == EventType.CLICK) {
                SharedPref.cacheCustomChannelClick(token, "", new Date().getTime(), context);
            } else {
                SharedPref.cacheCustomChannelDelivery(token, new Date().getTime(), context);
            }
        }
    }

    protected enum EventType {
        CLICK,
        DELIVERY,
    }
}
