package sdk.main.core

import com.gojek.mqtt.model.KeepAlive
import com.gojek.mqtt.model.MqttConnectOptions
import com.gojek.mqtt.model.ServerUri
import ir.intrack.android.sdk.BuildConfig
import sdk.main.core.MqttConfig.Companion.get
import java.util.UUID
import com.google.gson.annotations.SerializedName as SN

data class MqttConfig(
    @SN("host") private val hostValue: String? = null,
    @SN("port") private val portValue: Int = 8883,
    @SN("username") private var usernameValue: String? = "androidsdk-2.0.0-consumer",
    @SN("password") private val passwordValue: String? = "Re3utee1quooshojei1ihohjesie7ait",
) {
    val host get() = hostValue ?: setHostValueBaseOnFlavorName()
    val port get() = if (portValue != 0) portValue else 1883
    val username
        get(): String {
            if (usernameValue.isNullOrBlank()) {
                usernameValue = UUID.randomUUID().toString()
            }
            return usernameValue ?: ""
        }
    val password get() = passwordValue ?: ""

    companion object {
        private var currentConfig: MqttConfig = MqttConfig()

        fun update(config: MqttConfig) {
            currentConfig = config
        }

        fun get(): MqttConfig = currentConfig
    }

}

internal fun setHostValueBaseOnFlavorName(): String {
    return if (BuildConfig.DEBUG) "mq-stage.intrack.ir" else "an-mq.intrack.ir"
}

fun mqttConnectOptions(clientId: String): MqttConnectOptions = get().run {
    MqttConnectOptions.Builder()
        .serverUris(
            listOf(
                ServerUri(
                    host,
                    port,
                    if (port == 8883) "ssl" else "tcp"
                )
            )
        )
        .clientId(clientId)
        .userName(username)
        .password(password)
        .cleanSession(false)
        .keepAlive(KeepAlive(timeSeconds = 30))
        .build()
}
