package sdk.main.core

import java.util.Calendar
import java.util.Date
import com.google.gson.annotations.SerializedName as SN

private val Date.afterTTL
    get(): Date {
        val expDate = Calendar.getInstance()
        expDate.time = Date()
        expDate.add(Calendar.DATE, 28)

        return expDate.time;
    }

data class PushAmpCacheMessage(
    @SN("id")
    var id: String? = null,
    @SN("showed")
    var showed: Boolean = false,
    @SN("expDate")
    var expDate: Date = Date().afterTTL,
    @SN("data")
    var data: Map<String, String>?,
) {
    constructor(id: String, showed: Boolean, data: Map<String, String>) : this(
        id,
        showed,
        Date().afterTTL,
        data
    );
    constructor(id: String, showed: Boolean) : this(id, showed, Date().afterTTL, null);

    fun isExpired(): Boolean {
        return expDate.before(Date())
    }

}
