package sdk.main.core.ext

import android.os.Looper
import androidx.lifecycle.MutableLiveData
import kotlin.experimental.ExperimentalTypeInference


@OptIn(ExperimentalTypeInference::class)
@BuilderInference
fun <T> MutableLiveData<T>.emit(t: T? = null) {
    setOrPostValue(t)
}

fun <T> MutableLiveData<T>.setOrPostValue(t: T? = null) {
    if (Looper.myLooper() == Looper.getMainLooper()) {
        value = t
    } else {
        postValue(t)
    }
}