package sdk.main.core.inappmessaging.display.mraid

import android.util.DisplayMetrics
import com.google.gson.Gson

data class MraidDisplayMetrics(
    val density: Float,
    val widthPixels: Int,
    val heightPixels: Int,
) {
    constructor(displayMetrics: DisplayMetrics) : this(
        displayMetrics.density,
        displayMetrics.widthPixels,
        displayMetrics.heightPixels,
    )

    fun toJSON(): String = Gson().toJson(this)
}
