package sdk.main.core.inappmessaging.display.mraid.utils

import android.app.Activity
import android.content.Context
import android.content.MutableContextWrapper
import android.graphics.Point
import android.view.View
import android.view.ViewGroup
import sdk.main.core.inappmessaging.display.Dimension
import sdk.main.core.inappmessaging.display.UnitType

object ViewUtil {
    fun removeChildFromParent(view: View?) {
        if ((view != null) && (view.parent != null)) {
            (view.parent as ViewGroup).removeView(view)
        }
    }

    fun getTopContext(view: View?): Context? {
        if (view == null) {
            return null
        }
        var parent = view.parent

        if (parent !is View) {
            if (view.context is MutableContextWrapper) {
                return (view.context as MutableContextWrapper).baseContext
            }
            return view.context
        }

        while ((parent.parent != null) && (parent.parent is View)) {
            parent = parent.parent
        }

        return (parent as View).context
    }

    // returns screen size as { width, height } in pixels
    fun getScreenSizeAsPixels(activity: Activity): Array<Dimension> {
        val d = activity.windowManager.defaultDisplay
        val p = Point()
        d.getSize(p)

        val width = Dimension(p.x.toFloat(), UnitType.PX)
        val height = Dimension(p.y.toFloat(), UnitType.PX)

        return arrayOf(width, height)
    }
}
