package sdk.main.core.inappmessaging.model.message

import com.google.gson.Gson
import sdk.main.core.inappmessaging.display.Configuration
import sdk.main.core.inappmessaging.model.MessageType
import java.util.Date

data class IAMMessage(
    var id: String? = null,
    var communicationId: Int? = null,
    var layout: MessageType? = null,
    var title: String? = null,
    var description: String? = null,
    var image: String? = null,
    var backgroundImage: String? = null,
    var primaryButtonLabel: String? = null,
    var primaryButtonOnClick: String? = null,
    var secondaryButtonLabel: String? = null,
    var secondaryButtonOnClick: String? = null,
    var couponCode: String? = null,
    var showCount: Int = 0,
    var theme: Any?,
    var endDate: Date? = null,
    var whenAndWhereConditions: WhenAndWhereConditions? = WhenAndWhereConditions(),
    var html: String? = null,
    val config: Configuration? = Configuration(),
) {
    fun decreaseShowCount() = showCount--

    override fun toString(): String = Gson().toJson(this)
}
