package sdk.main.core.inappmessaging.model.message

import sdk.main.core.ext.withNegate
import sdk.main.core.inappmessaging.model.message.enumeration.Operator
import sdk.main.core.inappmessaging.model.message.enumeration.accepts

data class Predicates(
    var term: String? = null,
    var negate: Boolean = false,
    var operator: Operator? = null,
    var value: String? = null,
    var dataType: String? = null,
)

internal fun Predicates.accepts(event: EventModel): Boolean = withNegate(negate) {
    operator?.accepts(value, event.segmentation[term]) ?: false
}
