package sdk.main.core.inappmessaging.model.message

import sdk.main.core.ScreenUnion
import sdk.main.core.ext.withNegate
import sdk.main.core.inappmessaging.model.message.enumeration.Conjunction
import sdk.main.core.inappmessaging.model.message.enumeration.Operator
import sdk.main.core.inappmessaging.model.message.enumeration.accepts

data class Terms(
    var term: String? = null,
    var negate: Boolean = false,
    var operator: Operator? = null,
    var value: String? = null,
    var dataType: String? = null,
    var predicatesConjunction: Conjunction? = null,
    var predicates: ArrayList<Predicates> = arrayListOf(),
)

internal fun Terms.doesScreenCompliesTo(screenUnion: ScreenUnion): Boolean = withNegate(negate) {
    operator?.accepts(this, screenUnion.screenTitle) ?: false
}

internal fun Terms.accepts(event: EventModel): Boolean = withNegate(negate) {
    val keyAns = operator?.accepts(this, event.key) ?: false

    if (!keyAns) return@withNegate false

    val predicateAns = when (predicatesConjunction ?: Conjunction.AND) {
        Conjunction.AND -> predicates.all { it.accepts(event) }
        Conjunction.OR -> predicates.any { it.accepts(event) }
    }

    predicateAns
}

internal fun Terms.accepts(screenData: Map<String?, Any?>?): Boolean = withNegate(negate) {
    operator?.accepts(this, screenData?.get(term)) ?: false
}
