package sdk.main.core.pushmessaging

import android.content.Context
import android.content.res.ColorStateList
import android.graphics.Color
import android.os.Build
import android.widget.RemoteViews

import androidx.annotation.LayoutRes
import ir.intrack.android.sdk.R

class TimerRemoteViewBuilder(@LayoutRes private val layoutId: Int) {
    private var title: String? = null
    private var titleColor: String? = null
    private var message: String? = null
    private var messageColor: String? = null
    private var chronometerTextColor: String? = null
    private var progressBarColor: String? = null
    private var countdownDuration: Long = 0

    fun setTitle(title: String?): TimerRemoteViewBuilder {
        this.title = title
        return this
    }

    fun setTitleColor(color: String?): TimerRemoteViewBuilder {
        this.titleColor = color
        return this
    }

    fun setMessage(message: String?): TimerRemoteViewBuilder {
        this.message = message
        return this
    }

    fun setMessageColor(color: String?): TimerRemoteViewBuilder {
        this.messageColor = color
        return this
    }

    fun setChronometerTextColor(color: String?): TimerRemoteViewBuilder {
        this.chronometerTextColor = color
        return this
    }

    fun setProgressBarColor(color: String?): TimerRemoteViewBuilder {
        this.progressBarColor = color
        return this
    }

    fun setCountdownDuration(duration: Long): TimerRemoteViewBuilder{
        this.countdownDuration = duration
        return this
    }

    fun build(context: Context): RemoteViews {
        val remoteViews = RemoteViews(context.packageName, layoutId)

        titleConfiguration(remoteViews)

        descriptionConfiguration(remoteViews)

        chronometerConfiguration(remoteViews)

        progressBarConfiguration(remoteViews)

        return remoteViews
    }

    private fun chronometerConfiguration(remoteViews: RemoteViews) {
        chronometerTextColor?.let { color ->
            remoteViews.setTextColor(
                R.id.chronometer,
                Color.parseColor(color)
            )
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            remoteViews.setChronometerCountDown(R.id.chronometer, true)
        }
    }

    private fun descriptionConfiguration(remoteViews: RemoteViews) {
        message?.let {
            remoteViews.setTextViewText(R.id.description, it)
            messageColor?.let { color ->
                remoteViews.setTextColor(
                    R.id.description,
                    Color.parseColor(color)
                )
            }
        }
    }

    private fun progressBarConfiguration(remoteViews: RemoteViews) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            progressBarColor?.let { color ->
                remoteViews.setColorStateList(
                    R.id.notification_progressBar,
                    "setProgressTintList",
                    ColorStateList.valueOf(Color.parseColor(color))
                )
            }
        }
    }

    private fun titleConfiguration(remoteViews: RemoteViews) {
        title?.let {
            remoteViews.setTextViewText(R.id.title, it)
            titleColor?.let { color ->
                remoteViews.setTextColor(
                    R.id.title,
                    Color.parseColor(color)
                )
            }
        }
    }

}
