package sdk.main.core.pushmessaging

import ir.intrack.android.sdk.R

enum class TimerType(val timerLayoutResId: Int) {
    PLAIN(R.layout.layout_timer),
    PROGRESS_BAR(R.layout.layout_timer_progress),
    BIG(R.layout.layout_timer_large),
    ;

    companion object {
        fun fromString(type: String?): TimerType? {
            return try {
                type?.uppercase()?.let { TimerType.valueOf(it) }
            } catch (e: IllegalArgumentException) {
                PLAIN
            }
        }
    }
}
