package com.gojek.mqtt.client.config.v3

import android.util.Log
import com.gojek.courier.logging.ILogger

object MqttAndroidLogger : ILogger {
    private const val isDisabled = true
    override fun d(tag: String, msg: String) {
        //TODO: using SDK logger
        if (isDisabled) return
        Log.d(tag, "[ModuleIAM] Connection:  $msg")
    }

    override fun d(tag: String, msg: String, tr: Throwable) {
        if (isDisabled) return
        Log.d(tag, "[ModuleIAM] Connection: $msg", tr)
    }

    override fun e(tag: String, msg: String) {
        if (isDisabled) return
        Log.e(tag, "[ModuleIAM] Connection: $msg")
    }

    override fun e(tag: String, msg: String, tr: Throwable) {
        if (isDisabled) return
        Log.e(tag, "[ModuleIAM] Connection: $msg", tr)
    }

    override fun i(tag: String, msg: String) {
        if (isDisabled) return
        Log.i(tag, "[ModuleIAM] Connection: $msg")
    }

    override fun i(tag: String, msg: String, tr: Throwable) {
        if (isDisabled) return
        Log.i(tag, "[ModuleIAM] Connection: $msg", tr)
    }

    override fun v(tag: String, msg: String) {
        if (isDisabled) return
        Log.v(tag, "[ModuleIAM] Connection: $msg")
    }

    override fun v(tag: String, msg: String, tr: Throwable) {
        if (isDisabled) return
        Log.v(tag, "[ModuleIAM] Connection: $msg", tr)
    }

    override fun w(tag: String, msg: String) {
        if (isDisabled) return
        Log.w(tag, "[ModuleIAM] Connection: $msg")
    }

    override fun w(tag: String, msg: String, tr: Throwable) {
        if (isDisabled) return
        Log.w(tag, "[ModuleIAM] Connection: $msg", tr)
    }

    override fun w(tag: String, tr: Throwable) {
        if (isDisabled) return
        Log.w(tag, tr)
    }
}