package ir.intrack.android.sdk.prefs

import sdk.main.core.inappmessaging.model.message.IAMMessage

internal class CampaignDataPrefs() {
    private val viewsCountMaps = mutableMapOf<String, Int>()


    private fun screenViewCountKey(message: IAMMessage) =
        "SVC_" + message.id

    fun screenViewCount(message: IAMMessage) =
        viewsCountMaps[screenViewCountKey(message)]

    fun setScreenViewCount(message: IAMMessage, count: Int) {
        viewsCountMaps[screenViewCountKey(message)] = count
    }

    fun increaseScreenViewCount(message: IAMMessage) {
        setScreenViewCount(
            message, 1 + (if (screenViewCount(message) != null) screenViewCount(
                message
            ) else 0)!!
        )
    }

}
