package sdk.main.core;


import android.annotation.SuppressLint;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.os.Build;
import android.util.Log;

import androidx.annotation.RequiresApi;

/**
 * Background Job service to sync up for new notifications
 */
@SuppressLint("SpecifyJobSchedulerIdRange")
@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public class BackgroundJobService extends JobService {

    @Override
    public boolean onStartJob(final JobParameters params) {
        Context context = this.getApplicationContext();
        Log.d("AMPLIFICATION", "[PUSH_AMP] Job Service is starting");
        new Thread(new Runnable() {
            @Override
            public void run() {
                Log.d("AMPLIFICATION", "[PUSH_AMP] check with backend");
                jobFinished(params, true);
            }
        }).start();
        return true;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return true; //to ensure reschedule
    }
}
