package sdk.main.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import java.net.URLDecoder;


/**
 * ADB Testing
 * adb shell
 * am broadcast -a com.android.vending.INSTALL_REFERRER --es "referrer" "intrack_cid%3Dxxxxcidvaluexxxx%26intrack_cuid%3Dxxxxcuidvaluexxxx"
 **/
//******************************************************************************
class ReferrerReceiver extends BroadcastReceiver {
    private static final String key = "referrer";

    //--------------------------------------------------------------------------
    public ReferrerReceiver() {
    }

    //--------------------------------------------------------------------------
    public static String getReferrer(Context context) {
        // Return any persisted referrer value or null if we don't have a referrer.
        if (CoreInternal.sharedInstance().config_.sharedPref != null) {
            return CoreInternal.sharedInstance().config_.sharedPref.getInstallReferrer();
        } else {
            return SharedPref.getInstallReferrerStatic(context);
        }
    }

    public static void deleteReferrer(Context context) {
        // delete stored referrer.
        if (CoreInternal.sharedInstance().config_.sharedPref != null) {
            CoreInternal.sharedInstance().config_.sharedPref.deleteInstallReferrer();
        } else {
            SharedPref.deleteInstallReferrerStatic(context);
        }
    }

    //--------------------------------------------------------------------------
    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            // Make sure this is the intent we expect - it always should be.
            if ((null != intent) && (null != intent.getAction()) && (intent.getAction().equals("com.android.vending.INSTALL_REFERRER"))) {
                // This intent should have a referrer string attached to it.
                String rawReferrer = intent.getStringExtra(key);
                if (null != rawReferrer) {
                    // The string is usually URL Encoded, so we need to decode it.
                    String referrer = URLDecoder.decode(rawReferrer, "UTF-8");

                    // Log the referrer string.
                    if (CoreInternal.sharedInstance().isInitialized()) {
                        CoreInternal.sharedInstance().L.d("Referrer: " + referrer);
                    }

                    String[] parts = referrer.split("&");
                    String cid = null;
                    String uid = null;
                    for (String part : parts) {
                        if (part.startsWith("intrack_cid")) {
                            cid = part.replace("intrack_cid=", "").trim();
                        }
                        if (part.startsWith("intrack_cuid")) {
                            uid = part.replace("intrack_cuid=", "").trim();
                        }
                    }
                    String res = "";
                    if (cid != null) {
                        res += "&campaign_id=" + cid;
                    }
                    if (uid != null) {
                        res += "&campaign_user=" + uid;
                    }

                    if (CoreInternal.sharedInstance().isInitialized()) {
                        CoreInternal.sharedInstance().L.d("Processed: " + res);
                    }
                    // Persist the referrer string.
                    if (!res.equals("")) {
                        context.getSharedPreferences(key, Context.MODE_PRIVATE).edit().putString(key, res).apply();
                    }
                }
            }
        } catch (Exception e) {
            if (CoreInternal.sharedInstance().isInitialized()) {
                CoreInternal.sharedInstance().L.d(e.toString());
            }
        }
    }
}
