package sdk.main.core

import java.security.MessageDigest

class SdkChecksumGeneratorUtil {
    companion object {
        private val cs = arrayOf(
            'v',
            'N',
            'p',
            'B',
            '&',
            'V',
            'T',
            '^',
            'z',
            '4',
            '(',
            'j',
            '0',
            'A',
            'd',
            'f',
            'i',
            'c',
            'g',
            'K',
            'u',
            'a',
            '8',
            'W',
            '9',
            '!',
            'o',
            '2',
            'q',
            'e',
            'P',
            'r',
            '6',
            '7',
            't',
            '*',
            'L',
            's',
            'y',
            'Z',
            'F',
            'R',
            'J',
            'O',
            'm',
            'n',
            '1',
            'S',
            'b',
            'w',
            'x',
            '%',
            'D',
            'E',
            'h',
            'U',
            'M',
            '5',
            '@',
            '$',
            ')',
            'Q',
            '#',
            '3',
        )

        fun h(a: String, res: Int, `is`: Array<Int>): Int {
            var result = res
            `is`.forEach { i ->
                if (i < a.length) {
                    result = result.xor(a[i].code)
                }
            }
            return result
        }

        fun h0(a: String) = h(
            a,
            0x33,
            arrayOf(0, 1, 2, 7, 8, 11, 13, 15, 18, 19, 20, 24, 25, 26, 30, 31, 32, 38, 39)
        )

        fun h1(a: String) = h(a, 0x00, arrayOf(0, 1, 3, 5, 6, 10, 11, 15, 17, 32, 40))
        fun h2(a: String) = h(a, 0xc6, arrayOf(1, 4, 6, 8, 10, 13, 14, 15, 21, 25, 28, 30))
        fun h3(a: String) =
            h(a, 0x90, arrayOf(2, 3, 5, 7, 8, 9, 11, 14, 16, 17, 22, 23, 26, 29, 30))

        fun h4(a: String) = h(a, 0x27, arrayOf(0, 1, 2, 3, 4, 9, 12, 16, 19, 22, 23, 24))
        fun h5(a: String) =
            h(a, 0x23, arrayOf(1, 4, 7, 9, 11, 13, 15, 16, 20, 21, 23, 30, 31, 35, 38))

        fun h6(a: String) =
            h(a, 0x0f, arrayOf(3, 4, 8, 9, 15, 16, 17, 21, 15, 17, 19, 22, 24, 25, 26, 32, 35, 37))

        fun h7(a: String) = h(a, 0xf7, arrayOf(0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 13, 16, 18, 19))
        fun h8(a: String) = h(a, 0x1a, arrayOf(0, 10, 20, 30, 40, 50, 60, 70))
        fun h9(a: String) = h(a, 0x4b, arrayOf(2, 5, 6, 7, 10, 13, 16, 20, 31, 33, 37))

        fun z(z1In: Int, z2In: Int, z3In: Int, z4In: Int): Int {
            var b: Int
            var z1 = z1In
            var z2 = z2In
            var z3 = z3In
            var z4 = z4In
            b = z1.shl(6).xor(z1).ushr(13)
            z1 = z1.and(429496729).shl(18).xor(b)
            b = z2.shl(2).xor(z2).ushr(27)
            z2 = z2.and(429496728).shl(2).xor(b)
            b = z3.shl(13).xor(z3).ushr(21)
            z3 = z3.and(429496728).shl(7).xor(b)
            b = z4.shl(3).xor(z4).ushr(12)
            z4 = z4.and(429496716).shl(13).xor(b)
            return z1.xor(z2).xor(z3).xor(z4)
        }

        fun r(z1: Int, z2: Int, z3: Int, z4: Int): Char {
            val i = z(z1, z2, z3, z4) % 256
            var newI = (i % 128).ushr(1)
            if (i > 127) {
                newI = newI.xor(0x25)
            }
            if (i % 2 == 1) {
                newI = newI.xor(0x3B)
            }
            return cs[newI]
        }

        fun salt(date: String, deviceId: String, apiKey: String, packageName: String): String {
            val ss = 23
            val str = StringBuffer()
            (0 until ss).forEach { i ->
                if (i % 3 == 0) {
                    str.append(
                        r(
                            i * h1(deviceId) + h2(date) + h6(packageName),
                            h8(date) * h4(apiKey) + i,
                            h4(date) + h9(date) + h2(deviceId) + i * i,
                            h0(apiKey) * i * h7(deviceId) + 134 * h1(packageName)
                        )
                    )
                }

                if (i % 3 == 1) {
                    str.append(
                        r(
                            h5(date) + h8(deviceId) + h3(apiKey) + i,
                            h3(packageName) * 2 + h7(packageName) * h4(apiKey) * i,
                            h6(packageName) * h1(deviceId) + h1(deviceId) + 83 * i,
                            h0(deviceId) * h1(date) + 8 + i * i
                        )
                    )
                }

                if (i % 3 == 2) {
                    str.append(
                        r(
                            h5(deviceId) * i * i + h6(apiKey) * h9(packageName),
                            h3(apiKey) * h9(date) * 3 * i,
                            h2(deviceId) * h0(packageName) + h4(apiKey) * i,
                            h9(apiKey) * h2(date) * h3(packageName) + i * i * i
                        )
                    )
                }
            }
            return str.toString()
        }

        fun mc(c: Char): String {
            when (c) {
                '0' -> return "2"
                '1' -> return "3"
                '2' -> return "4"
                '3' -> return "5"
                '4' -> return "6"
                '5' -> return "7"
                '6' -> return "8"
                '7' -> return "9"
                '8' -> return "a"
                '9' -> return "b"
                'a' -> return "c"
                'b' -> return "d"
                'c' -> return "e"
                'd' -> return "f"
                'e' -> return "0"
                'f' -> return "1"
                else -> return "0"
            }
        }

        fun checksum(
            json: String,
            date: String,
            deviceId: String,
            appKey: String,
            appId: String
        ): String {
            val sha256Hash = toSha256Hash(json + salt(date, deviceId, appKey, appId))
            if (sha256Hash == null) {
                return "checksum_calc_failed"
            }
            val sb = StringBuffer(sha256Hash)
            // replace Fibonacci numbers with mc
            arrayOf(1, 2, 3, 5, 8, 13, 21, 34, 55).forEach {
                sb.replace(it, it + 1, mc(sb[it]))
            }
            return sb.toString()
        }

        fun toSha256Hash(toHash: String): String? {
            var hash: String? = null
            try {
                val digest = MessageDigest.getInstance("SHA-256")
                var bytes = toHash.toByteArray(charset("UTF-8"))
                digest.update(bytes, 0, bytes.size)
                bytes = digest.digest()
                hash = bytes.joinToString("") { "%02x".format(it) }
            } catch (_: Exception) {
            }
            return hash
        }
    }
}
