package sdk.main.core.inappmessaging

import sdk.main.core.InAppMessageListener.ErrorMessageReason

interface InAppMessagingDisplayCallbacks {
    // log the campaign impression:
    fun impressionDetected()

    // log when a message is dismissed, and specify dismiss type
    fun messageDismissed(dismissType: InAppMessagingDismissType?)

    // log when a message is tap (ie: button, in the modal view)  with the ActionUrl followed
    fun messageClicked(actionUrl: String?)

    // log when there is an issue rendering the content (ie, image_url is invalid
    // or file_type is unsupported
    fun displayErrorEncountered(inAppMessagingErrorReason: ErrorMessageReason?)

    enum class InAppMessagingDismissType {
        // Unspecified dismiss type
        UNKNOWN_DISMISS_TYPE,

        // Message was dismissed automatically after a timeout
        AUTO,

        // Message was dismissed by clicking on cancel button or outside the message
        CLICK,

        // Message was swiped
        SWIPE
    }
}
