package sdk.main.core.inappmessaging.display

data class Overlay(
    private val color: String?, // Hex code for color like.
    private val opacity: Float?, // Opacity percentage (0-1)
    private val dismissible: Boolean? = true,
) {

    fun getColor(): String =
        if (color.isNullOrEmpty()) "#000000" else if (!color.startsWith("#")) "#$color" else color

    fun getOpacity(): Float = opacity?.takeIf { it in 0f..1f } ?: 0.3f

    fun isDismissible(): Boolean = dismissible ?: true

    override fun equals(other: Any?): Boolean {
        return if (this === other) {
            true
        } else if (other !is Overlay) {
            false
        } else {
            (this.getColor() == other.getColor()) &&
                (this.getOpacity() == other.getOpacity()) &&
                (this.isDismissible() == other.isDismissible())
        }
    }

    override fun hashCode(): Int {
        return super.hashCode()
    }
}
