package sdk.main.core.inappmessaging.display.mraid

import com.google.gson.Gson
import sdk.main.core.CoreProxy

data class MraidEnvironment(
    val version: String = "3.0",
    var sdk: String = CoreProxy.getSdkName(),
    var sdkVersion: String = CoreProxy.getSdkVersion(),
    var sdkVersionCode: Long = CoreProxy.getSDKVersionCode(),
    var platform: String = CoreProxy.getOS(),
    var platformVersion: String = CoreProxy.getOSVersion(),
    var platformVersionCode: Long = CoreProxy.getOSVersionCode(),
    var appId: String = CoreProxy.getPackageName(),
    var ifa: String = CoreProxy.getIFA(),
    var limitAdTracking: Boolean = CoreProxy.isTrackingLimitedEnabled(),
    var coppa: Boolean = CoreProxy.isCoppaEnabled(),
) {
    fun toJSON(): String = Gson().toJson(this)
}
