package sdk.main.core.inappmessaging.display.mraid

import android.webkit.ConsoleMessage
import sdk.main.core.inappmessaging.display.Configuration

interface MraidListener {
    fun onInitFinished()
    fun onClose()
    fun onStartLoadingHtml()
    fun onHtmlLoaded()
    fun onHtmlError(errorCode: Int? = null, message: String?)
    /**
     * @param consoleMessage String containing the console message.
     * @return {@code true} if the message is handled by the listener.
     */
    fun onJSConsole(consoleMessage: ConsoleMessage?): Boolean
    fun onClicked(url: String?)
    fun onUnload(shouldSendCloseEvent: Boolean)
    fun onConfigurationUpdated(newConfig: Configuration)
    fun onInjectJavaScript(uri: String)
}
