package sdk.main.core.inappmessaging.model.message.enumeration

import sdk.main.core.inappmessaging.model.message.Terms

enum class Operator {
    EQUAL_TO,
    NOT_EQUAL_TO,
    IS_NOT_EMPTY,
    ONE_OF,
    NONE_OF,
    STARTS_WITH,
    ENDS_WITH,
    MATCHES_REGEX,
    CONTAINS,
    LESS_THAN,
    LESS_THAN_OR_EQUAL_TO,
    GREATER_THAN,
    GREATER_THAN_OR_EQUAL_TO,
    BETWEEN,
    NOT_BETWEEN,
}

private val String?.toDoubleRange: ClosedFloatingPointRange<Double>?
    get() = this?.run {
        val parts = split(",")
        if (parts.size == 2) {
            val start = parts[0].toDoubleOrNull() ?: return@run null
            val end = parts[1].toDoubleOrNull() ?: return@run null
            start..end
        } else {
            null
        }
    }

fun Operator?.accepts(term: Terms, obj: Any?) = accepts(
    term.value, obj
)

fun Operator?.accepts(acceptableValue: String?, obj: Any?): Boolean {
    val objStr = obj?.toString()
    return when (this ?: Operator.EQUAL_TO) {
        Operator.EQUAL_TO -> acceptableValue == objStr
        Operator.NOT_EQUAL_TO -> acceptableValue != objStr
        Operator.IS_NOT_EMPTY -> objStr?.isNotEmpty() == true
        Operator.ONE_OF -> acceptableValue?.split(",")?.contains(objStr) == true
        Operator.NONE_OF -> acceptableValue?.split(",")?.contains(objStr) != true
        Operator.STARTS_WITH -> objStr?.startsWith(acceptableValue ?: "") == true
        Operator.ENDS_WITH -> objStr?.endsWith(acceptableValue ?: "") == true
        Operator.MATCHES_REGEX -> acceptableValue?.toRegex()?.matches(objStr ?: "") == true
        Operator.CONTAINS -> objStr?.contains(acceptableValue ?: "") == true
        Operator.LESS_THAN -> (objStr?.toDoubleOrNull()
            ?: return false) < (acceptableValue?.toDoubleOrNull() ?: return false)

        Operator.LESS_THAN_OR_EQUAL_TO -> (objStr?.toDoubleOrNull()
            ?: return false) <= (acceptableValue?.toDoubleOrNull() ?: return false)

        Operator.GREATER_THAN -> (objStr?.toDoubleOrNull()
            ?: return false) > (acceptableValue?.toDoubleOrNull() ?: return false)

        Operator.GREATER_THAN_OR_EQUAL_TO -> (objStr?.toDoubleOrNull()
            ?: return false) >= (acceptableValue?.toDoubleOrNull() ?: return false)

        Operator.BETWEEN -> acceptableValue.toDoubleRange?.contains(
            (objStr?.toDoubleOrNull() ?: return false)
        ) == true

        Operator.NOT_BETWEEN -> acceptableValue.toDoubleRange?.contains(
            (objStr?.toDoubleOrNull() ?: return false)
        ) != true
    }
}
