package sdk.main.core.pushmessaging

enum class CountDownType {
    DURATION,
    END_TIME;

    companion object {
        fun fromString(type: String?): CountDownType? {
            return try {
                type?.uppercase()?.let { CountDownType.valueOf(it) }
            } catch (e: IllegalArgumentException) {
                END_TIME
            }
        }
    }
}
