package sdk.main.core.pushmessaging

import android.app.NotificationManager
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import sdk.main.core.PushHandler

class DismissNotificationReceiver : BroadcastReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        if (intent.action?.startsWith(TimerNotificationService.ACTION_DISMISS_NOTIFICATION) == true) {
            val notificationId =
                intent.getIntExtra(TimerNotificationService.EXTRA_NOTIFICATION_ID, -1)
            if (notificationId != -1) {
                val manager =
                    context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
                val serviceIntent = Intent(context, TimerNotificationService::class.java)
                    .setAction(TimerNotificationService.ACTION_STOP_TIMER)
                    .putExtra(TimerNotificationService.EXTRA_NOTIFICATION_ID, notificationId)

                context.startService(serviceIntent)
                manager.cancel(notificationId)
                PushHandler.recordPushDismissedEvent(notificationId.toString(), context)
            }
        }
    }
}
