package sdk.main.core.pushmessaging

import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.Bundle
import androidx.core.app.NotificationCompat
import androidx.core.net.toUri
import sdk.main.core.PushHandler
import sdk.main.core.PushTrampolineActivity

object NotificationUtils {

    fun setNotificationButtons(
        context: Context,
        builder: NotificationCompat.Builder,
        msg: PushMessage,
        notificationId: Int,
        notificationIntent: Intent? = null
    ) {
        for (i in msg.buttons.indices) {
            val button = msg.buttons[i]

            val trampolineIntent = Intent(context, PushTrampolineActivity::class.java).apply {
                setPackage(context.packageName)
                addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                putExtra(
                    PushHandler.EXTRA_INTENT,
                    actionIntent(context, notificationIntent, msg, i + 1)
                )

                if (msg.type == MessageType.TIMER) {
                    putExtra(TimerNotificationService.EXTRA_NOTIFICATION_ID, notificationId)
                    data = "notification://$notificationId".toUri()
                }
            }
            val pendingIntent = PendingIntent.getActivity(
                context,
                notificationId + i + 1,
                trampolineIntent,
                pendingIntentFlags,
            )

            builder.addAction(button.icon, button.title, pendingIntent)
        }

        val dismissIntent = Intent(context, DismissNotificationReceiver::class.java)
            .setAction("${TimerNotificationService.ACTION_DISMISS_NOTIFICATION}$notificationId")
            .putExtra(TimerNotificationService.EXTRA_NOTIFICATION_ID, notificationId)
            .setData("notification_dismiss://$notificationId".toUri())

        val dismissPendingIntent = PendingIntent.getBroadcast(
            context,
            notificationId,
            dismissIntent,
            pendingIntentFlags,
        )
        builder.setDeleteIntent(dismissPendingIntent)

        if (msg.type == MessageType.TIMER && msg.dismissLabel != null) {
            builder.addAction(0, msg.dismissLabel, dismissPendingIntent).build()
        }
    }

    fun setNotificationClickAction(
        context: Context,
        builder: NotificationCompat.Builder,
        msg: PushMessage,
        notificationId: Int,
        notificationIntent: Intent?
    ) {
        val trampolineIntent = Intent(context, PushTrampolineActivity::class.java).apply {
            setPackage(context.packageName)
            addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            putExtra(TimerNotificationService.EXTRA_NOTIFICATION_ID, notificationId)
            if (msg.type == MessageType.TIMER) {
                setData("notification://$notificationId".toUri())
            }
        }
        trampolineIntent.putExtra(
            PushHandler.EXTRA_INTENT,
            actionIntent(context, notificationIntent, msg, 0)
        )

        val pendingIntent = PendingIntent.getActivity(
            context,
            notificationId,
            trampolineIntent,
            pendingIntentFlags,
        )

        builder.setContentIntent(pendingIntent)
    }

    private val pendingIntentFlags =
        PendingIntent.FLAG_UPDATE_CURRENT or (if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) PendingIntent.FLAG_IMMUTABLE else 0)

    private fun actionIntent(
        context: Context,
        notificationIntent: Intent?,
        message: PushMessage,
        index: Int
    ): Intent? {
        val intent = if (notificationIntent == null) {
            context.packageManager.getLaunchIntentForPackage(context.packageName)
        } else {
            notificationIntent.clone() as Intent
        }
        val bundle = Bundle()
        bundle.putParcelable(PushHandler.EXTRA_MESSAGE, message)
        intent?.apply {
            putExtra(PushHandler.EXTRA_MESSAGE, bundle)
            putExtra(PushHandler.EXTRA_ACTION_INDEX, index)
        }
        return intent
    }
}
