package sdk.main.core.pushmessaging

import android.content.Context
import android.net.Uri

/**
 * Interface representing a button associated with a push message.
 */
interface PushMessageButton {

    /**
     * Index of the button (starts from 1).
     */
    val index: Int

    /**
     * Title of the button.
     */
    val title: String

    /**
     * Link associated with the button.
     */
    val link: Uri

    /**
     * Icon resource ID for the button. Default can be 0.
     */
    val icon: Int

    /**
     * Record action event for this button, usually after a click.
     *
     * @param context Context to run in.
     */
    fun recordAction(context: Context)
}
