/*
 * 2stepverification Android SDK
 *
 * @version     1.0.0
 * @copyright   Copyright © 2017, 2stepverification.ir.
 * @license     http://opensource.org/licenses/mit-license.php The MIT License (MIT).
 * @author      Amir Moradabadi
 * @repository  https://github.com/2stepverification/android-sdk
 * @website     http://www.2stepverification.ir
 * @support     info@2stepverification.ir
 *
 */

package ir.twostepverification.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

import ir.twostepverification.model.Api;

class AsyncHttpResponse extends Handler {
    private ResponseHandlerInterface responseHandlerInterface;
    private String requestId;
    private Service service;

    AsyncHttpResponse(ResponseHandlerInterface responseHandlerInterface, String requestId, Service service) {
        this.responseHandlerInterface = responseHandlerInterface;
        this.requestId = requestId;
        this.service = service;
    }


    @Override
    public void handleMessage(Message msg) {
        super.handleMessage(msg);

        Bundle bundle = msg.getData();
        Service service = Service.get(bundle.getInt("service"));
        byte[] data = bundle.getByteArray("data");
        String message = bundle.getString("message");

        if (data == null) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -200, message);
            return;
        }

        switch (service) {
            case RequestCall:
                handleRequestCallService(data);
                break;
            case VerifyCall:
                handleVerifyCallService(data);
                break;
            case RequestSMS:
                handleRequestSMSService(data);
                break;
            case VerifySMS:
                handleVerifySMSService(data);
                break;
            case RequestEmail:
                handleRequestEmailService(data);
                break;
            case VerifyEmail:
                handleVerifyEmailService(data);
                break;
            case RequestTelegram:
                handleRequestTelegramService(data);
                break;
            case VerifyTelegram:
                handleVerifyTelegramService(data);
                break;
            case RequestWhatsapp:
                handleRequestWhatsappService(data);
                break;
            case VerifyWhatsapp:
                handleVerifyWhatsappService(data);
                break;
        }


    }

    private void handleRequestCallService(byte[] data) {
        try {
            Api.RequestTel builder = Api.RequestTel.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }

    private void handleVerifyCallService(byte[] data) {
        try {
            Api.VerifyTel builder = Api.VerifyTel.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }


    private void handleRequestSMSService(byte[] data) {
        try {
            Api.RequestSMS builder = Api.RequestSMS.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }

    private void handleVerifySMSService(byte[] data) {
        try {
            Api.VerifySMS builder = Api.VerifySMS.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }

    private void handleRequestEmailService(byte[] data) {
        try {
            Api.RequestEmail builder = Api.RequestEmail.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }

    private void handleVerifyEmailService(byte[] data) {
        try {
            Api.VerifyEmail builder = Api.VerifyEmail.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }


    private void handleRequestTelegramService(byte[] data) {
        try {
            Api.RequestTelegram builder = Api.RequestTelegram.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }

    private void handleVerifyTelegramService(byte[] data) {
        try {
            Api.VerifyTelegram builder = Api.VerifyTelegram.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }

    private void handleRequestWhatsappService(byte[] data) {
        try {
            Api.RequestWhatsapp builder = Api.RequestWhatsapp.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }

    private void handleVerifyWhatsappService(byte[] data) {
        try {
            Api.VerifyWhatsapp builder = Api.VerifyWhatsapp.parseFrom(data);
            if (builder.getStatus() == 1) {
                this.responseHandlerInterface.onSuccess(this.requestId, this.service);
                return;
            }
            this.responseHandlerInterface.onFailure(this.requestId, this.service, builder.getCode(), builder.getMsg());
        } catch (Exception e) {
            this.responseHandlerInterface.onFailure(this.requestId, this.service, -100, e.getMessage());
        }
    }


}
