/*
 * 2stepverification Android SDK
 *
 * @version     1.0.0
 * @copyright   Copyright © 2017, 2stepverification.ir.
 * @license     http://opensource.org/licenses/mit-license.php The MIT License (MIT).
 * @author      Amir Moradabadi
 * @repository  https://github.com/2stepverification/android-sdk
 * @website     http://www.2stepverification.ir
 * @support     info@2stepverification.ir
 *
 */

package ir.twostepverification.sdk;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


public class TwoStepVerificationClient {

    private String apikey;
    private String apiauthorization;


    private ExecutorService executorService = Executors.newCachedThreadPool();

    public TwoStepVerificationClient(String apikey, String apiauthorization) {
        this.apikey = apikey;
        this.apiauthorization = apiauthorization;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().equals("");
    }

    public void requestCall(String requestId, String number, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(number)) {
            throw new IllegalArgumentException("number must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.RequestCall, responseHandler, apikey, apiauthorization, requestId, number));
    }

    public void verifyCall(String requestId, String code, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(code)) {
            throw new IllegalArgumentException("code must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.VerifyCall, responseHandler, apikey, apiauthorization, requestId, code));
    }


    public void requestSMS(String requestId, String number, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(number)) {
            throw new IllegalArgumentException("number must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.RequestSMS, responseHandler, apikey, apiauthorization, requestId, number));
    }

    public void verifySMS(String requestId, String code, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(code)) {
            throw new IllegalArgumentException("code must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.VerifySMS, responseHandler, apikey, apiauthorization, requestId, code));
    }


    public void requestEmail(String requestId, String email, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(email)) {
            throw new IllegalArgumentException("email must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.RequestEmail, responseHandler, apikey, apiauthorization, requestId, email));
    }

    public void verifyEmail(String requestId, String code, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(code)) {
            throw new IllegalArgumentException("code must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.VerifyEmail, responseHandler, apikey, apiauthorization, requestId, code));
    }


    public void requestTelegram(String requestId, String number, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(number)) {
            throw new IllegalArgumentException("number must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.RequestTelegram, responseHandler, apikey, apiauthorization, requestId, number));
    }

    public void verifyTelegram(String requestId, String code, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(code)) {
            throw new IllegalArgumentException("code must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.VerifyTelegram, responseHandler, apikey, apiauthorization, requestId, code));
    }


    public void requestWhatsapp(String requestId, String number, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(number)) {
            throw new IllegalArgumentException("number must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.RequestWhatsapp, responseHandler, apikey, apiauthorization, requestId, number));
    }

    public void verifyWhatsapp(String requestId, String code, ResponseHandlerInterface responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (isEmpty(requestId)) {
            throw new IllegalArgumentException("requestId must not be null or empty");
        }
        if (isEmpty(code)) {
            throw new IllegalArgumentException("code must not be null or empty");
        }
        executorService.submit(new AsyncHttpRequest(Service.VerifyWhatsapp, responseHandler, apikey, apiauthorization, requestId, code));
    }


}
