/*
 * 2stepverification Android SDK
 *
 * @version     1.0.0
 * @copyright   Copyright © 2017, 2stepverification.ir.
 * @license     http://opensource.org/licenses/mit-license.php The MIT License (MIT).
 * @author      Amir Moradabadi
 * @repository  https://github.com/2stepverification/android-sdk
 * @website     http://www.2stepverification.ir
 * @support     info@2stepverification.ir
 *
 */

package ir.twostepverification.sdk;

public interface ResponseHandlerInterface {

    /**
     * Notifies callback, that request was handled successfully
     */
    void onSuccess(String requestId, Service service);

    /**
     * Returns if request was completed with error code or failure of implementation
     */
    void onFailure(String requestId, Service service, int code, String message);

}
