/*
 * 2stepverification Android SDK
 *
 * @version     1.0.0
 * @copyright   Copyright © 2017, 2stepverification.ir.
 * @license     http://opensource.org/licenses/mit-license.php The MIT License (MIT).
 * @author      Amir Moradabadi
 * @repository  https://github.com/2stepverification/android-sdk
 * @website     http://www.2stepverification.ir
 * @support     info@2stepverification.ir
 *
 */

package ir.twostepverification.sdk;

public enum Service {

    undefined(0),

    RequestCall(10),
    VerifyCall(11),

    RequestSMS(20),
    VerifySMS(21),

    RequestEmail(30),
    VerifyEmail(31),

    RequestTelegram(40),
    VerifyTelegram(41),

    RequestWhatsapp(50),
    VerifyWhatsapp(51);

    private int value;

    Service(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static Service get(int value) {
        if (value == 0) {
            return undefined;
        }
        Service[] arr$ = values();
        for (Service val : arr$) {
            if (val.value == value) {
                return val;
            }
        }
        return undefined;
    }
}