/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.FieldInitLink;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;
import javassist.expr.ExprEditor;

class CtClassType
extends CtClass {
    protected ClassPool classPool;
    protected boolean wasChanged;
    protected boolean wasFrozen;
    protected ClassFile classfile;
    private CtField fieldsCache;
    private CtConstructor constructorsCache;
    private CtConstructor classInitializerCache;
    private CtMethod methodsCache;
    private FieldInitLink fieldInitializers;
    private Hashtable hiddenMethods;
    private int uniqueNumberSeed;

    CtClassType(String name, ClassPool cp) {
        super(name);
        this.classPool = cp;
        this.wasFrozen = false;
        this.wasChanged = false;
        this.classfile = null;
        this.fieldInitializers = null;
        this.hiddenMethods = null;
        this.uniqueNumberSeed = 0;
        this.eraseCache();
    }

    CtClassType(InputStream ins, ClassPool cp) throws IOException {
        this((String)null, cp);
        this.classfile = new ClassFile(new DataInputStream(ins));
        this.qualifiedName = this.classfile.getName();
    }

    protected void eraseCache() {
        this.fieldsCache = null;
        this.constructorsCache = null;
        this.classInitializerCache = null;
        this.methodsCache = null;
    }

    public ClassFile getClassFile2() {
        if (this.classfile != null) {
            return this.classfile;
        }
        try {
            byte[] b = this.classPool.readSource(this.getName());
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
            this.classfile = new ClassFile(dis);
            return this.classfile;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public boolean isModified() {
        return this.wasChanged;
    }

    public boolean isFrozen() {
        return this.wasFrozen;
    }

    void freeze() {
        this.wasFrozen = true;
    }

    void checkModify() throws RuntimeException {
        super.checkModify();
        this.wasChanged = true;
    }

    public void defrost() {
        this.wasFrozen = false;
    }

    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        String cname = clazz.getName();
        if (this == clazz || this.getName().equals(cname)) {
            return true;
        }
        ClassFile file = this.getClassFile2();
        String supername = file.getSuperclass();
        if (supername != null && supername.equals(cname)) {
            return true;
        }
        String[] ifs = file.getInterfaces();
        int num = ifs.length;
        int i = 0;
        while (i < num) {
            if (ifs[i].equals(cname)) {
                return true;
            }
            ++i;
        }
        if (supername != null && this.classPool.get(supername).subtypeOf(clazz)) {
            return true;
        }
        i = 0;
        while (i < num) {
            if (this.classPool.get(ifs[i]).subtypeOf(clazz)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setName(String name) throws RuntimeException {
        String oldname = this.getName();
        if (name.equals(oldname)) {
            return;
        }
        this.classPool.checkNotFrozen(name, "the class with the new name is frozen");
        ClassFile cf = this.getClassFile2();
        super.setName(name);
        cf.setName(name);
        this.eraseCache();
        this.classPool.classNameChanged(oldname, this);
    }

    public void replaceClassName(ClassMap classnames) throws RuntimeException {
        String oldClassName = this.getName();
        String newClassName = (String)classnames.get(Descriptor.toJvmName(oldClassName));
        if (newClassName != null) {
            newClassName = Descriptor.toJavaName(newClassName);
            this.classPool.checkNotFrozen(newClassName, "the class " + newClassName + " is frozen");
        }
        super.replaceClassName(classnames);
        ClassFile cf = this.getClassFile2();
        cf.renameClass(classnames);
        this.eraseCache();
        if (newClassName != null) {
            super.setName(newClassName);
            this.classPool.classNameChanged(oldClassName, this);
        }
    }

    public void replaceClassName(String oldname, String newname) throws RuntimeException {
        String thisname = this.getName();
        if (thisname.equals(oldname)) {
            this.setName(newname);
        } else {
            super.replaceClassName(oldname, newname);
            this.getClassFile2().renameClass(oldname, newname);
            this.eraseCache();
        }
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public int getModifiers() {
        int acc = this.getClassFile2().getAccessFlags();
        acc = AccessFlag.clear(acc, 32);
        return AccessFlag.toModifier(acc);
    }

    public void setModifiers(int mod) {
        this.checkModify();
        int acc = AccessFlag.of(mod) | 0x20;
        this.getClassFile2().setAccessFlags(acc);
    }

    public boolean subclassOf(CtClass superclass) {
        if (superclass == null) {
            return false;
        }
        String superName = superclass.getName();
        CtClass curr = this;
        try {
            while (curr != null) {
                if (curr.getName().equals(superName)) {
                    return true;
                }
                curr = ((CtClass)curr).getSuperclass();
            }
        }
        catch (Exception ignored) {}
        return false;
    }

    public CtClass getSuperclass() throws NotFoundException {
        String supername = this.getClassFile2().getSuperclass();
        if (supername == null) {
            return null;
        }
        return this.classPool.get(supername);
    }

    public void setSuperclass(CtClass clazz) throws CannotCompileException {
        this.checkModify();
        this.getClassFile2().setSuperclass(clazz.getName());
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        String[] ifs = this.getClassFile2().getInterfaces();
        int num = ifs.length;
        CtClass[] ifc = new CtClass[num];
        int i = 0;
        while (i < num) {
            ifc[i] = this.classPool.get(ifs[i]);
            ++i;
        }
        return ifc;
    }

    public void setInterfaces(CtClass[] list) {
        String[] ifs;
        this.checkModify();
        if (list == null) {
            ifs = new String[]{};
        } else {
            int num = list.length;
            ifs = new String[num];
            int i = 0;
            while (i < num) {
                ifs[i] = list[i].getName();
                ++i;
            }
        }
        this.getClassFile2().setInterfaces(ifs);
    }

    public void addInterface(CtClass anInterface) {
        this.checkModify();
        if (anInterface != null) {
            this.getClassFile2().addInterface(anInterface.getName());
        }
    }

    public CtField[] getFields() {
        ArrayList alist = new ArrayList();
        CtClassType.getFields(alist, this);
        return alist.toArray(new CtField[alist.size()]);
    }

    private static void getFields(ArrayList alist, CtClass cc) {
        if (cc == null) {
            return;
        }
        try {
            CtClassType.getFields(alist, cc.getSuperclass());
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass[] ifs = cc.getInterfaces();
            int num = ifs.length;
            int i = 0;
            while (i < num) {
                CtClassType.getFields(alist, ifs[i]);
                ++i;
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        CtField cf = ((CtClassType)cc).getFieldsCache();
        while (cf != null) {
            if (Modifier.isPublic(cf.getModifiers())) {
                alist.add(cf);
            }
            cf = cf.next;
        }
    }

    public CtField getField(String name) throws NotFoundException {
        try {
            return this.getDeclaredField(name);
        }
        catch (NotFoundException e) {
            try {
                CtClass[] ifs = this.getInterfaces();
                int num = ifs.length;
                int i = 0;
                while (i < num) {
                    try {
                        return ifs[i].getField(name);
                    }
                    catch (NotFoundException e2) {
                        ++i;
                    }
                }
            }
            catch (NotFoundException e3) {
                // empty catch block
            }
        }
        try {
            CtClass s = this.getSuperclass();
            if (s != null) {
                return s.getField(name);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        throw new NotFoundException(name);
    }

    public CtField[] getDeclaredFields() {
        CtField cf = this.getFieldsCache();
        int num = CtField.count(cf);
        CtField[] cfs = new CtField[num];
        int i = 0;
        while (cf != null) {
            cfs[i++] = cf;
            cf = cf.next;
        }
        return cfs;
    }

    protected CtField getFieldsCache() {
        if (this.fieldsCache == null) {
            List list = this.getClassFile2().getFields();
            int n = list.size();
            int i = 0;
            while (i < n) {
                FieldInfo finfo = (FieldInfo)list.get(i);
                this.fieldsCache = CtField.append(this.fieldsCache, new CtField(finfo, (CtClass)this));
                ++i;
            }
        }
        return this.fieldsCache;
    }

    public CtField getDeclaredField(String name) throws NotFoundException {
        CtField cf = this.getFieldsCache();
        while (cf != null) {
            if (cf.getName().equals(name)) {
                return cf;
            }
            cf = cf.next;
        }
        throw new NotFoundException(name);
    }

    public CtBehavior[] getDeclaredBehaviors() {
        CtConstructor cc = this.getConstructorsCache();
        CtMethod cm = this.getMethodsCache();
        int num = CtMethod.count(cm) + CtConstructor.count(cc);
        CtBehavior[] cb = new CtBehavior[num];
        int i = 0;
        while (cc != null) {
            cb[i++] = cc;
            cc = cc.next;
        }
        while (cm != null) {
            cb[i++] = cm;
            cm = cm.next;
        }
        return cb;
    }

    public CtConstructor[] getConstructors() {
        CtConstructor[] cons = this.getDeclaredConstructors();
        if (cons.length == 0) {
            return cons;
        }
        int n = 0;
        int i = cons.length;
        while (--i >= 0) {
            if (!Modifier.isPublic(cons[i].getModifiers())) continue;
            ++n;
        }
        CtConstructor[] result = new CtConstructor[n];
        n = 0;
        i = cons.length;
        while (--i >= 0) {
            CtConstructor c = cons[i];
            if (!Modifier.isPublic(c.getModifiers())) continue;
            result[n++] = c;
        }
        return result;
    }

    public CtConstructor getConstructor(String desc) throws NotFoundException {
        CtConstructor cc = this.getConstructorsCache();
        while (cc != null) {
            if (cc.getMethodInfo2().getDescriptor().equals(desc)) {
                return cc;
            }
            cc = cc.next;
        }
        return super.getConstructor(desc);
    }

    public CtConstructor[] getDeclaredConstructors() {
        CtConstructor cc = this.getConstructorsCache();
        int num = CtConstructor.count(cc);
        CtConstructor[] ccs = new CtConstructor[num];
        int i = 0;
        while (cc != null) {
            ccs[i++] = cc;
            cc = cc.next;
        }
        return ccs;
    }

    protected CtConstructor getConstructorsCache() {
        if (this.constructorsCache == null) {
            List list = this.getClassFile2().getMethods();
            int n = list.size();
            int i = 0;
            while (i < n) {
                MethodInfo minfo = (MethodInfo)list.get(i);
                if (minfo.isConstructor()) {
                    this.constructorsCache = CtConstructor.append(this.constructorsCache, new CtConstructor(minfo, (CtClass)this));
                }
                ++i;
            }
        }
        return this.constructorsCache;
    }

    public CtConstructor getClassInitializer() {
        MethodInfo minfo;
        if (this.classInitializerCache == null && (minfo = this.getClassFile2().getStaticInitializer()) != null) {
            this.classInitializerCache = new CtConstructor(minfo, (CtClass)this);
        }
        return this.classInitializerCache;
    }

    public CtMethod[] getMethods() {
        HashMap h = new HashMap();
        CtClassType.getMethods0(h, this);
        return h.values().toArray(new CtMethod[0]);
    }

    private static void getMethods0(HashMap h, CtClass cc) {
        try {
            CtClass[] ifs = cc.getInterfaces();
            int size = ifs.length;
            int i = 0;
            while (i < size) {
                CtClassType.getMethods0(h, ifs[i]);
                ++i;
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass s = cc.getSuperclass();
            if (s != null) {
                CtClassType.getMethods0(h, s);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        if (cc instanceof CtClassType) {
            CtMethod cm = ((CtClassType)cc).getMethodsCache();
            while (cm != null) {
                if (Modifier.isPublic(cm.getModifiers())) {
                    h.put(cm, cm);
                }
                cm = cm.next;
            }
        }
    }

    public CtMethod getMethod(String name, String desc) throws NotFoundException {
        CtMethod m = CtClassType.getMethod0(this, name, desc);
        if (m != null) {
            return m;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    private static CtMethod getMethod0(CtClass cc, String name, String desc) {
        if (cc instanceof CtClassType) {
            CtMethod cm = ((CtClassType)cc).getMethodsCache();
            while (cm != null) {
                if (cm.getName().equals(name) && cm.getMethodInfo2().getDescriptor().equals(desc)) {
                    return cm;
                }
                cm = cm.next;
            }
        }
        try {
            CtMethod m;
            CtClass s = cc.getSuperclass();
            if (s != null && (m = CtClassType.getMethod0(s, name, desc)) != null) {
                return m;
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass[] ifs = cc.getInterfaces();
            int size = ifs.length;
            int i = 0;
            while (i < size) {
                CtMethod m = CtClassType.getMethod0(ifs[i], name, desc);
                if (m != null) {
                    return m;
                }
                ++i;
            }
        }
        catch (NotFoundException e) {}
        return null;
    }

    public CtMethod[] getDeclaredMethods() {
        CtMethod cm = this.getMethodsCache();
        int num = CtMethod.count(cm);
        CtMethod[] cms = new CtMethod[num];
        int i = 0;
        while (cm != null) {
            cms[i++] = cm;
            cm = cm.next;
        }
        return cms;
    }

    public CtMethod getDeclaredMethod(String name) throws NotFoundException {
        CtMethod m = this.getMethodsCache();
        while (m != null) {
            if (m.getName().equals(name)) {
                return m;
            }
            m = m.next;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    public CtMethod getDeclaredMethod(String name, CtClass[] params) throws NotFoundException {
        String desc = Descriptor.ofParameters(params);
        CtMethod m = this.getMethodsCache();
        while (m != null) {
            if (m.getName().equals(name) && m.getMethodInfo2().getDescriptor().startsWith(desc)) {
                return m;
            }
            m = m.next;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    protected CtMethod getMethodsCache() {
        if (this.methodsCache == null) {
            List list = this.getClassFile2().getMethods();
            int n = list.size();
            int i = 0;
            while (i < n) {
                MethodInfo minfo = (MethodInfo)list.get(i);
                if (minfo.isMethod()) {
                    this.methodsCache = CtMethod.append(this.methodsCache, new CtMethod(minfo, this));
                }
                ++i;
            }
        }
        return this.methodsCache;
    }

    public void addField(CtField f, String init) throws CannotCompileException {
        this.addField(f, CtField.Initializer.byExpr(init));
    }

    /*
     * Unable to fully structure code
     */
    public void addField(CtField f, CtField.Initializer init) throws CannotCompileException {
        block3: {
            this.checkModify();
            if (f.getDeclaringClass() != this) {
                throw new CannotCompileException("cannot add");
            }
            if (init == null) {
                init = f.getInit();
            }
            this.getFieldsCache();
            this.fieldsCache = CtField.append(this.fieldsCache, f);
            this.getClassFile2().addField(f.getFieldInfo2());
            if (init == null) break block3;
            fil = new FieldInitLink(f, init);
            link = this.fieldInitializers;
            if (link != null) ** GOTO lbl17
            this.fieldInitializers = fil;
            break block3;
lbl-1000:
            // 1 sources

            {
                link = link.next;
lbl17:
                // 2 sources

                ** while (link.next != null)
            }
lbl18:
            // 1 sources

            link.next = fil;
        }
    }

    public CtConstructor makeClassInitializer() throws CannotCompileException {
        CtConstructor clinit = this.getClassInitializer();
        if (clinit != null) {
            return clinit;
        }
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        this.modifyClassConstructor(cf, code, 0, 0);
        return this.getClassInitializer();
    }

    public void addConstructor(CtConstructor c) throws CannotCompileException {
        this.checkModify();
        if (c.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getConstructorsCache();
        this.constructorsCache = CtConstructor.append(this.constructorsCache, c);
        this.getClassFile2().addMethod(c.getMethodInfo2());
    }

    public void addMethod(CtMethod m) throws CannotCompileException {
        this.checkModify();
        if (m.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMethodsCache();
        this.methodsCache = CtMethod.append(this.methodsCache, m);
        this.getClassFile2().addMethod(m.getMethodInfo2());
        if ((m.getModifiers() & 0x400) != 0) {
            this.setModifiers(this.getModifiers() | 0x400);
        }
    }

    public byte[] getAttribute(String name) {
        AttributeInfo ai = this.getClassFile2().getAttribute(name);
        if (ai == null) {
            return null;
        }
        return ai.get();
    }

    public void setAttribute(String name, byte[] data) {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        cf.addAttribute(new AttributeInfo(cf.getConstPool(), name, data));
    }

    public void instrument(CodeConverter converter) throws CannotCompileException {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        ConstPool cp = cf.getConstPool();
        List list = cf.getMethods();
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            converter.doit(this, minfo, cp);
            ++i;
        }
    }

    public void instrument(ExprEditor editor) throws CannotCompileException {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        List list = cf.getMethods();
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            editor.doit(this, minfo);
            ++i;
        }
    }

    void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        ClassFile cf = this.getClassFile2();
        try {
            this.modifyClassConstructor(cf);
            this.modifyConstructors(cf);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        this.wasFrozen = true;
        try {
            cf.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new CannotCompileException(e);
        }
    }

    protected void modifyClassConstructor(ClassFile cf) throws CannotCompileException, NotFoundException {
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        Javac jv = new Javac(code, this);
        int stacksize = 0;
        boolean doInit = false;
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            CtField f = fi.field;
            if (Modifier.isStatic(f.getModifiers())) {
                doInit = true;
                int s = fi.init.compileIfStatic(f.getType(), f.getName(), code, jv);
                if (stacksize < s) {
                    stacksize = s;
                }
            }
            fi = fi.next;
        }
        if (doInit) {
            this.modifyClassConstructor(cf, code, stacksize, 0);
        }
    }

    private void modifyClassConstructor(ClassFile cf, Bytecode code, int stacksize, int localsize) throws CannotCompileException {
        MethodInfo m = cf.getStaticInitializer();
        if (m == null) {
            code.add(177);
            code.setMaxStack(stacksize);
            code.setMaxLocals(localsize);
            m = new MethodInfo(cf.getConstPool(), "<clinit>", "()V");
            m.setAccessFlags(8);
            m.setCodeAttribute(code.toCodeAttribute());
            cf.addMethod(m);
        } else {
            CodeAttribute codeAttr = m.getCodeAttribute();
            if (codeAttr == null) {
                throw new CannotCompileException("empty <clinit>");
            }
            try {
                int maxlocals;
                CodeIterator it = codeAttr.iterator();
                int pos = it.insertEx(code.get());
                it.insert(code.getExceptionTable(), pos);
                int maxstack = codeAttr.getMaxStack();
                if (maxstack < stacksize) {
                    codeAttr.setMaxStack(stacksize);
                }
                if ((maxlocals = codeAttr.getMaxLocals()) < localsize) {
                    codeAttr.setMaxLocals(localsize);
                }
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
    }

    protected void modifyConstructors(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        ConstPool cp = cf.getConstPool();
        List list = cf.getMethods();
        int n = list.size();
        int i = 0;
        while (i < n) {
            CodeAttribute codeAttr;
            MethodInfo minfo = (MethodInfo)list.get(i);
            if (minfo.isConstructor() && (codeAttr = minfo.getCodeAttribute()) != null) {
                try {
                    Bytecode init = new Bytecode(cp, 0, codeAttr.getMaxLocals());
                    CtClass[] params = Descriptor.getParameterTypes(minfo.getDescriptor(), this.classPool);
                    int stacksize = this.makeFieldInitializer(init, params);
                    CtClassType.insertAuxInitializer(codeAttr, init, stacksize);
                }
                catch (BadBytecode e) {
                    throw new CannotCompileException(e);
                }
            }
            ++i;
        }
    }

    private static void insertAuxInitializer(CodeAttribute codeAttr, Bytecode initializer, int stacksize) throws BadBytecode {
        CodeIterator it = codeAttr.iterator();
        int index = it.skipSuperConstructor();
        if (index < 0 && (index = it.skipThisConstructor()) >= 0) {
            return;
        }
        int pos = it.insertEx(initializer.get());
        it.insert(initializer.getExceptionTable(), pos);
        int maxstack = codeAttr.getMaxStack();
        if (maxstack < stacksize) {
            codeAttr.setMaxStack(stacksize);
        }
    }

    private int makeFieldInitializer(Bytecode code, CtClass[] parameters) throws CannotCompileException, NotFoundException {
        int stacksize = 0;
        Javac jv = new Javac(code, this);
        try {
            jv.recordParams(parameters, false);
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            int s;
            CtField f = fi.field;
            if (!Modifier.isStatic(f.getModifiers()) && stacksize < (s = fi.init.compile(f.getType(), f.getName(), code, parameters, jv))) {
                stacksize = s;
            }
            fi = fi.next;
        }
        return stacksize;
    }

    Hashtable getHiddenMethods() {
        if (this.hiddenMethods == null) {
            this.hiddenMethods = new Hashtable();
        }
        return this.hiddenMethods;
    }

    int getUniqueNumber() {
        return this.uniqueNumberSeed++;
    }
}

