/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SourceFileAttribute;

public final class ClassFile {
    ConstPool constPool;
    int thisClass;
    int accessFlags;
    int superClass;
    int[] interfaces;
    LinkedList fields;
    LinkedList methods;
    LinkedList attributes;
    String thisclassname;

    public ClassFile(DataInputStream in) throws IOException {
        this.read(in);
    }

    public ClassFile(boolean isInterface, String classname, String superclass) {
        this.constPool = new ConstPool(classname);
        this.thisClass = this.constPool.getThisClassInfo();
        this.accessFlags = isInterface ? 1568 : 32;
        this.initSuperclass(superclass);
        this.interfaces = null;
        this.fields = new LinkedList();
        this.methods = new LinkedList();
        this.thisclassname = classname;
        this.attributes = new LinkedList();
        this.attributes.add(new SourceFileAttribute(this.constPool, ClassFile.getSourcefileName(this.thisclassname)));
    }

    private void initSuperclass(String superclass) {
        this.superClass = superclass != null ? this.constPool.addClassInfo(superclass) : this.constPool.addClassInfo("java.lang.Object");
    }

    private static String getSourcefileName(String qname) {
        int index = qname.lastIndexOf(46);
        if (index >= 0) {
            qname = qname.substring(index + 1);
        }
        return qname + ".java";
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int acc) {
        this.accessFlags = acc | 0x20;
    }

    public String getName() {
        return this.thisclassname;
    }

    public void setName(String name) {
        this.renameClass(this.thisclassname, name);
    }

    public String getSuperclass() {
        return this.constPool.getClassInfo(this.superClass);
    }

    public int getSuperclassId() {
        return this.superClass;
    }

    public void setSuperclass(String superclass) throws CannotCompileException {
        if (superclass == null) {
            superclass = "java.lang.Object";
        }
        try {
            this.superClass = this.constPool.addClassInfo(superclass);
            LinkedList list = this.methods;
            int n = list.size();
            int i = 0;
            while (i < n) {
                MethodInfo minfo = (MethodInfo)list.get(i);
                minfo.setSuperclass(superclass);
                ++i;
            }
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
    }

    public final void renameClass(String oldname, String newname) {
        if (oldname.equals(newname)) {
            return;
        }
        if (oldname.equals(this.thisclassname)) {
            this.thisclassname = newname;
        }
        oldname = Descriptor.toJvmName(oldname);
        newname = Descriptor.toJvmName(newname);
        this.constPool.renameClass(oldname, newname);
        LinkedList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            String desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            ++i;
        }
        list = this.fields;
        n = list.size();
        int i2 = 0;
        while (i2 < n) {
            FieldInfo finfo = (FieldInfo)list.get(i2);
            String desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            ++i2;
        }
    }

    public final void renameClass(Map classnames) {
        String jvmNewThisName = (String)classnames.get(Descriptor.toJvmName(this.thisclassname));
        if (jvmNewThisName != null) {
            this.thisclassname = Descriptor.toJavaName(jvmNewThisName);
        }
        this.constPool.renameClass(classnames);
        LinkedList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            String desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, classnames));
            ++i;
        }
        list = this.fields;
        n = list.size();
        int i2 = 0;
        while (i2 < n) {
            FieldInfo finfo = (FieldInfo)list.get(i2);
            String desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, classnames));
            ++i2;
        }
    }

    public String[] getInterfaces() {
        if (this.interfaces == null) {
            return new String[0];
        }
        int n = this.interfaces.length;
        String[] list = new String[n];
        int i = 0;
        while (i < n) {
            list[i] = this.constPool.getClassInfo(this.interfaces[i]);
            ++i;
        }
        return list;
    }

    public void setInterfaces(String[] nameList) {
        if (nameList != null) {
            int n = nameList.length;
            this.interfaces = new int[n];
            int i = 0;
            while (i < n) {
                this.interfaces[i] = this.constPool.addClassInfo(nameList[i]);
                ++i;
            }
        }
    }

    public void addInterface(String name) {
        int info = this.constPool.addClassInfo(name);
        if (this.interfaces == null) {
            this.interfaces = new int[1];
            this.interfaces[0] = info;
        } else {
            int n = this.interfaces.length;
            int[] newarray = new int[n + 1];
            System.arraycopy(this.interfaces, 0, newarray, 0, n);
            newarray[n] = info;
            this.interfaces = newarray;
        }
    }

    public List getFields() {
        return this.fields;
    }

    public void addField(FieldInfo finfo) {
        this.fields.add(finfo);
    }

    public List getMethods() {
        return this.methods;
    }

    public MethodInfo getMethod(String name) {
        LinkedList list = this.methods;
        int n = list.size();
        int i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            if (minfo.getName().equals(name)) {
                return minfo;
            }
            ++i;
        }
        return null;
    }

    public MethodInfo getStaticInitializer() {
        return this.getMethod("<clinit>");
    }

    public void addMethod(MethodInfo minfo) {
        this.methods.add(minfo);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String name) {
        LinkedList list = this.attributes;
        int n = list.size();
        int i = 0;
        while (i < n) {
            AttributeInfo ai = (AttributeInfo)list.get(i);
            if (ai.getName().equals(name)) {
                return ai;
            }
            ++i;
        }
        return null;
    }

    public void addAttribute(AttributeInfo info) {
        AttributeInfo.remove(this.attributes, info.getName());
        this.attributes.add(info);
    }

    public String getSourceFile() {
        SourceFileAttribute sf = (SourceFileAttribute)this.getAttribute("SourceFile");
        if (sf == null) {
            return null;
        }
        return sf.getFileName();
    }

    private void read(DataInputStream in) throws IOException {
        int i;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("non class file");
        }
        int major = in.readUnsignedShort();
        int minor = in.readUnsignedShort();
        this.constPool = new ConstPool(in);
        this.accessFlags = in.readUnsignedShort();
        this.thisClass = in.readUnsignedShort();
        this.constPool.setThisClassInfo(this.thisClass);
        this.superClass = in.readUnsignedShort();
        int n = in.readUnsignedShort();
        if (n == 0) {
            this.interfaces = null;
        } else {
            this.interfaces = new int[n];
            i = 0;
            while (i < n) {
                this.interfaces[i] = in.readUnsignedShort();
                ++i;
            }
        }
        ConstPool cp = this.constPool;
        n = in.readUnsignedShort();
        this.fields = new LinkedList();
        i = 0;
        while (i < n) {
            this.addField(new FieldInfo(cp, in));
            ++i;
        }
        n = in.readUnsignedShort();
        this.methods = new LinkedList();
        i = 0;
        while (i < n) {
            this.addMethod(new MethodInfo(cp, in));
            ++i;
        }
        this.attributes = new LinkedList();
        n = in.readUnsignedShort();
        i = 0;
        while (i < n) {
            this.addAttribute(AttributeInfo.read(cp, in));
            ++i;
        }
        this.thisclassname = this.constPool.getClassInfo(this.thisClass);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(-889275714);
        out.writeShort(3);
        out.writeShort(45);
        this.constPool.write(out);
        out.writeShort(this.accessFlags);
        out.writeShort(this.thisClass);
        out.writeShort(this.superClass);
        int n = this.interfaces == null ? 0 : this.interfaces.length;
        out.writeShort(n);
        int i = 0;
        while (i < n) {
            out.writeShort(this.interfaces[i]);
            ++i;
        }
        LinkedList list = this.fields;
        n = list.size();
        out.writeShort(n);
        i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            finfo.write(out);
            ++i;
        }
        list = this.methods;
        n = list.size();
        out.writeShort(n);
        i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            minfo.write(out);
            ++i;
        }
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, out);
    }
}

