/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.jboss.util.file.DirectoryArchiveBrowser;
import org.jboss.util.file.JarArchiveBrowser;

public abstract class ArchiveBrowser {
    public static Iterator getBrowser(URL uRL, Filter filter) {
        if (uRL.getProtocol().equals("file")) {
            File file = null;
            try {
                file = new File(new URI(uRL.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("Not a valid URL: " + uRL, uRISyntaxException);
            }
            if (file.isDirectory()) {
                return new DirectoryArchiveBrowser(file, filter);
            }
            return new JarArchiveBrowser(file, filter);
        }
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

