/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.aop;

import org.jboss.aop.*;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.aop.util.MethodHashing;
import org.jboss.util.NestedRuntimeException;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.List;

/**
 * CollectionInterceptorUtil contains helper methods for the interceptors of
 * the different collection types.
 *
 * @author <a href="mailto:harald@gliebe.de">Harald Gliebe</a>
 * @authro Ben Wang
 */
public class CollectionInterceptorUtil
{
   static Logger logger_ = Logger.getLogger(CollectionInterceptorUtil.class.getName());

   public static ClassProxy createProxy(Class clazz, Interceptor interceptor)
         throws Exception
   {
      ClassProxy result = ClassProxyFactory.newInstance(clazz);
      InstanceAdvisor advisor = result._getInstanceAdvisor();
      advisor.appendInterceptor(interceptor);
      return result;
   }

   public static Map getMethodMap(Class clazz)
   {
      Map result = ClassProxyFactory.getMethodMap(clazz.getName());
      if (result == null) {
         try {
            ClassProxyFactory.newInstance(clazz);
         } catch (Exception e) {
            throw new NestedRuntimeException(e);
         }
         result = ClassProxyFactory.getMethodMap(clazz.getName());
      }
      return result;
   }

   public static Map getManagedMethods(Class clazz)
   {
      Method tostring = null;
      try {
         tostring = Object.class.getDeclaredMethod("toString", new Class[0]);
      } catch (NoSuchMethodException e) {
         e.printStackTrace();
         throw new NestedRuntimeException("getManagedMathods: " +e);
      }

      Map managedMethods = new HashMap();
      try {
         Method[] methods = clazz.getDeclaredMethods();
         for (int i = 0; i < methods.length; i++) {
            long hash = MethodHashing.methodHash(methods[i]);
            managedMethods.put(new Long(hash), methods[i]);
         }
         // Add toString to ManagedMethod
         long hash = MethodHashing.methodHash(tostring);
         managedMethods.put(new Long(hash), tostring);
      } catch (Exception ignored) {
         ignored.printStackTrace();
      }
      return managedMethods;
   }

   public static Object invoke(Invocation invocation,
                               Object interceptor,
                               Map methodMap,
                               Map managedMethods)
         throws Throwable
   {

      if (invocation instanceof MethodInvocation) {
         MethodInvocation methodInvocation = (MethodInvocation) invocation;
         Long methodHash = new Long(methodInvocation.getMethodHash());
         Method method = (Method) managedMethods.get(methodHash);
         if (logger_.isDebugEnabled() && method != null) {
            logger_.trace("invoke(): method intercepted " + method.getName());
         }
         Object[] args = methodInvocation.getArguments();
         if (method != null) {
            return method.invoke(interceptor, args);
         } else {
            method = methodInvocation.getMethod();
            if (method == null) {
               method = (Method) methodMap.get(methodHash);
            }

            logger_.trace("invke(): invoke non-managed method: " +method.toString());
            Object target = methodInvocation.getTargetObject();
            if(target == null) {
               throw new NestedRuntimeException("CollectionInterceptorUtil.invoke(): targetObject is null." +
                     " Can't invoke " +method.toString());
            }
            return method.invoke(target, args);
//            return method.invoke(interceptor, args);
         }
      }
      return invocation.invokeNext();
   }

}
