package org.jboss.cache.eviction;

/**
 * Interface for all eviction algorithm
 *
 * @author Ben Wang 2-2004
 */
public interface EvictionAlgorithm
{
   /**
    * Entry point for evictin algorithm. This is an api called by the EvictionTimerTask
    * to process the node events in waiting and actual pruning, if necessary.
    * @param region Region that this algorithm will operate on.
    */
   void process(Region region) throws EvictionException;

   /**
    * Reset the whole eviction queue. Queue may needs to be reset due to corrupted state, for example.
    * @param region  Region that this algorithm will operate on.
    */
   void resetEvictionQueue(Region region);
}
