/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.cache.aop.util.Null;

public class CachedSetImpl
extends AbstractSet {
    protected PojoCache cache_;
    protected AbstractCollectionInterceptor interceptor_;

    public CachedSetImpl(PojoCache cache, AbstractCollectionInterceptor interceptor) {
        this.cache_ = cache;
        this.interceptor_ = interceptor;
    }

    protected Set getNodeChildren() {
        try {
            return AopUtil.getNodeChildren(this.cache_, this.getFqn());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Fqn getFqn() {
        return this.interceptor_.getFqn();
    }

    public int size() {
        return this.keySet().size();
    }

    public Iterator iterator() {
        return new IteratorImpl(this.keySet());
    }

    public boolean add(Object o) {
        String keyString;
        Collection keys = this.keySet();
        IteratorImpl iter = new IteratorImpl(keys);
        while (iter.hasNext()) {
            if (iter.next() != o) continue;
            return false;
        }
        int key = keys.size();
        while (keys.contains(keyString = Integer.toString(key))) {
            ++key;
        }
        try {
            this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), keyString), Null.toNullObject(o));
            return true;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(Object o) {
        Iterator iter = this.iterator();
        if (o == null) {
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                return true;
            }
        } else {
            while (iter.hasNext()) {
                if (!o.equals(iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[").append(key).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        try {
            Set set = (Set)o;
            return set.size() == this.keySet().size() && this.containsAll(set);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    private Collection keySet() {
        Set children = this.getNodeChildren();
        return children == null ? Collections.EMPTY_SET : children;
    }

    private class IteratorImpl
    implements Iterator {
        private Iterator iterator;
        private Object key;

        private IteratorImpl(Collection keys) {
            this.iterator = keys.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.key = this.iterator.next();
            try {
                return Null.toNullValue(CachedSetImpl.this.cache_.getObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), this.key)));
            }
            catch (CacheException e) {
                throw new RuntimeException(e);
            }
        }

        public void remove() throws IllegalStateException {
            if (this.key == null) {
                throw new IllegalStateException();
            }
            try {
                CachedSetImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), this.key));
            }
            catch (CacheException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

