/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

public class LRUConfiguration
implements EvictionConfiguration {
    private static final Log log = LogFactory.getLog((Class)LRUConfiguration.class);
    private int maxNodes;
    private int timeToLiveSeconds;
    private int maxAgeSeconds;

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public void setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public void parseXMLConfig(Element element) throws ConfigureException {
        String name = element.getAttribute("name");
        if (name == null || name.equals("")) {
            throw new ConfigureException("Name is required for the eviction region");
        }
        String maxNodes = XmlHelper.getAttr(element, "maxNodes", "attribute", "name");
        if (maxNodes != null && !maxNodes.equals("")) {
            this.setMaxNodes(Integer.parseInt(maxNodes));
        } else {
            this.setMaxNodes(0);
        }
        String timeToLive = XmlHelper.getAttr(element, "timeToIdleSeconds", "attribute", "name");
        if (timeToLive == null && (timeToLive = XmlHelper.getAttr(element, "timeToLiveSeconds", "attribute", "name")) == null) {
            throw new ConfigureException("LRUConfiguration.parseXMLConfig(): Null timeToLiveSeconds element");
        }
        this.setTimeToLiveSeconds(Integer.parseInt(timeToLive));
        String maxAge = XmlHelper.getAttr(element, "maxAgeSeconds", "attribute", "name");
        if (maxAge != null && !maxAge.equals("")) {
            this.setMaxAgeSeconds(Integer.parseInt(maxAge));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseConfig: name -- " + name + " maxNodes -- " + this.getMaxNodes() + " timeToLiveSeconds -- " + this.getTimeToLiveSeconds() + " maxAgeSeconds -- " + this.getMaxAgeSeconds()));
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("LRUConfiguration: timeToLiveSeconds = ").append(this.getTimeToLiveSeconds()).append(" maxAgeSeconds =");
        str.append(this.getMaxAgeSeconds()).append(" maxNodes =").append(this.getMaxNodes());
        return str.toString();
    }
}

