/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.marshall.JavaObjectStreamFactory;
import org.jboss.cache.marshall.ObjectStreamFactory;

public class ObjectSerializationFactory {
    static boolean useJBossSerialization = false;
    private static Log log = LogFactory.getLog((Class)ObjectSerializationFactory.class);
    static ObjectStreamFactory factory = new JavaObjectStreamFactory();

    public static ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return factory.createObjectOutputStream(out);
    }

    public static ObjectInputStream createObjectInputStream(byte[] bytes) throws IOException {
        return factory.createObjectInputStream(bytes);
    }

    public static boolean useJBossSerialization() {
        return useJBossSerialization;
    }

    static {
        String useJBossSerializationStr = System.getProperty("serialization.jboss", "true");
        useJBossSerialization = Boolean.valueOf(useJBossSerializationStr);
        try {
            if (useJBossSerialization) {
                factory = (ObjectStreamFactory)Class.forName("org.jboss.cache.marshall.JBossObjectStreamFactory").newInstance();
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to load JBossObjectStreamFactory.  Perhaps jboss-serialization jar not loaded?", (Throwable)e);
            log.error((Object)"Falling back to java serialization.");
        }
    }
}

