/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.PayloadKey;

public class Invocation {
    public static final String[] INVOKE_SIGNATURE = new String[]{"org.jboss.invocation.Invocation"};
    public Map transient_payload;
    public Map as_is_payload;
    public Map payload = new HashMap();
    protected InvocationContext invocationContext;
    protected Object[] args;
    protected Object objectName;
    protected Method method;

    public Invocation() {
        this.as_is_payload = new HashMap();
        this.transient_payload = new HashMap();
    }

    public Invocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) {
        this.as_is_payload = new HashMap();
        this.transient_payload = new HashMap();
        this.setId(id);
        this.setMethod(m);
        this.setArguments(args);
        this.setTransaction(tx);
        this.setPrincipal(identity);
        this.setCredential(credential);
    }

    public void setValue(Object key, Object value) {
        this.setValue(key, value, PayloadKey.PAYLOAD);
    }

    public void setValue(Object key, Object value, PayloadKey type) {
        if (type == PayloadKey.TRANSIENT) {
            this.transient_payload.put(key, value);
        } else if (type == PayloadKey.AS_IS) {
            this.as_is_payload.put(key, value);
        } else if (type == PayloadKey.PAYLOAD) {
            this.payload.put(key, value);
        } else {
            throw new IllegalArgumentException("Unknown PayloadKey: " + type);
        }
    }

    public Object getValue(Object key) {
        Object rtn = this.payload.get(key);
        if (rtn != null) {
            return rtn;
        }
        rtn = this.as_is_payload.get(key);
        if (rtn != null) {
            return rtn;
        }
        rtn = this.transient_payload.get(key);
        return rtn;
    }

    public Object getPayloadValue(Object key) {
        return this.payload.get(key);
    }

    public void setTransaction(Transaction tx) {
        this.as_is_payload.put(InvocationKey.TRANSACTION, tx);
    }

    public Transaction getTransaction() {
        return (Transaction)this.as_is_payload.get(InvocationKey.TRANSACTION);
    }

    public void setPrincipal(Principal principal) {
        this.as_is_payload.put(InvocationKey.PRINCIPAL, principal);
    }

    public Principal getPrincipal() {
        return (Principal)this.as_is_payload.get(InvocationKey.PRINCIPAL);
    }

    public void setCredential(Object credential) {
        this.payload.put(InvocationKey.CREDENTIAL, credential);
    }

    public Object getCredential() {
        return this.getPayloadValue(InvocationKey.CREDENTIAL);
    }

    public void setObjectName(Object objectName) {
        this.objectName = objectName;
    }

    public Object getObjectName() {
        return this.objectName;
    }

    public void setType(InvocationType type) {
        this.as_is_payload.put(InvocationKey.TYPE, type);
    }

    public InvocationType getType() {
        InvocationType type = InvocationType.LOCAL;
        InvocationType invType = (InvocationType)this.as_is_payload.get(InvocationKey.TYPE);
        if (invType != null) {
            type = invType;
        }
        return type;
    }

    public void setId(Object id) {
        this.payload.put(InvocationKey.CACHE_ID, id);
    }

    public Object getId() {
        return this.getPayloadValue(InvocationKey.CACHE_ID);
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setArguments(Object[] arguments) {
        this.args = arguments;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public void setInvocationContext(InvocationContext ctx) {
        this.invocationContext = ctx;
    }

    public void setEnterpriseContext(Object ctx) {
        this.transient_payload.put(InvocationKey.ENTERPRISE_CONTEXT, ctx);
    }

    public Object getEnterpriseContext() {
        return this.transient_payload.get(InvocationKey.ENTERPRISE_CONTEXT);
    }
}

