/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.ServerException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.tm.TransactionPropagationContextFactory;

public class JRMPInvokerProxy
implements Invoker,
Externalizable {
    private static final long serialVersionUID = -3713605626489646730L;
    protected Invoker remoteInvoker;
    protected static TransactionPropagationContextFactory tpcFactory = null;
    public static int MAX_RETRIES = 10;

    public static void setTPCFactory(TransactionPropagationContextFactory tpcf) {
        tpcFactory = tpcf;
    }

    public JRMPInvokerProxy() {
    }

    public JRMPInvokerProxy(Invoker remoteInvoker) {
        this.remoteInvoker = remoteInvoker;
    }

    public String getServerHostName() throws Exception {
        return this.remoteInvoker.getServerHostName();
    }

    public Object getTransactionPropagationContext() throws SystemException {
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    public Object invoke(Invocation invocation) throws Exception {
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        int i = 0;
        while (i < MAX_RETRIES) {
            try {
                MarshalledObject result = (MarshalledObject)this.remoteInvoker.invoke(mi);
                return result.get();
            }
            catch (ConnectException ce) {
                if (i + 1 < MAX_RETRIES) {
                    Thread.sleep(1L);
                }
                throw ce;
            }
            catch (ServerException ex) {
                if (ex.detail instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)ex.detail;
                }
                if (ex.detail instanceof TransactionRolledbackException) {
                    throw (TransactionRolledbackException)ex.detail;
                }
                throw ex;
            }
            ++i;
        }
        throw new Exception("Unreachable statement");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.remoteInvoker instanceof RemoteStub) {
            out.writeObject(this.remoteInvoker);
        } else {
            Remote replacement = RemoteObject.toStub(this.remoteInvoker);
            out.writeObject(replacement);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.remoteInvoker = (Invoker)in.readObject();
    }
}

